/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.cards.z.ZurgoAndOjutaiEffect;
import mage.constants.PutCards;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchAllEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ZurgoAndOjutaiTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedEvent> {
    ZurgoAndOjutaiTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LookLibraryAndPickControllerEffect(3, 1, PutCards.HAND, PutCards.BOTTOM_ANY));
        this.addEffect((Effect)new ZurgoAndOjutaiEffect());
        this.setTriggerPhrase("Whenever one or more Dragons you control deal combat damage to a player or battle, ");
    }

    private ZurgoAndOjutaiTriggeredAbility(ZurgoAndOjutaiTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ZurgoAndOjutaiTriggeredAbility copy() {
        return new ZurgoAndOjutaiTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ALL;
    }

    public boolean checkEvent(DamagedEvent event, Game game) {
        if (!event.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        Permanent defender = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.hasSubtype(SubType.DRAGON, game) && permanent.isControlledBy(this.getControllerId()) && (defender != null && defender.isBattle(game) || game.getPlayer(event.getTargetId()) != null);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List permanents = this.getFilteredEvents((BatchEvent)((DamagedBatchAllEvent)event), game).stream().map(GameEvent::getSourceId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
        return true;
    }
}

