/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.z;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ZurzothChaosRiderEffect
extends OneShotEffect {
    private final Set<UUID> playerIds = new HashSet<UUID>();

    ZurzothChaosRiderEffect(Set<UUID> playerIds) {
        super(Outcome.Benefit);
        this.playerIds.addAll(playerIds);
    }

    private ZurzothChaosRiderEffect(ZurzothChaosRiderEffect effect) {
        super((OneShotEffect)effect);
        this.playerIds.addAll(effect.playerIds);
    }

    public ZurzothChaosRiderEffect copy() {
        return new ZurzothChaosRiderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player;
            if (!this.playerIds.contains(playerId) || (player = game.getPlayer(playerId)) == null) continue;
            player.drawCards(1, source, game);
            player.discard(1, true, false, source, game);
        }
        return true;
    }
}

