/*
 * Decompiled with CFR 0.152.
 */
package mage.sets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.g.GoblinTrenches;
import mage.cards.p.PropheticBolt;
import mage.cards.repository.CardInfo;
import mage.constants.Rarity;
import mage.constants.SetType;
import mage.util.RandomUtil;

public class MysteryBooster
extends ExpansionSet {
    private static final MysteryBooster instance = new MysteryBooster();
    protected final Map<Integer, List<CardInfo>> boosterMap = new HashMap<Integer, List<CardInfo>>();

    public static MysteryBooster getInstance() {
        return instance;
    }

    private MysteryBooster() {
        super("Mystery Booster", "MB1", ExpansionSet.buildDate((int)2019, (int)11, (int)7), SetType.REMIX);
        this.hasBoosters = true;
        this.hasBasicLands = false;
        this.cards.add(new ExpansionSet.SetCardInfo("Goblin Trenches", 203, Rarity.RARE, GoblinTrenches.class));
        this.cards.add(new ExpansionSet.SetCardInfo("Prophetic Bolt", 231, Rarity.RARE, PropheticBolt.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Card> createBooster() {
        Map<Integer, List<CardInfo>> map = this.boosterMap;
        synchronized (map) {
            if (this.boosterMap.isEmpty()) {
                this.initBoosterMap();
            }
        }
        ArrayList<Card> booster = new ArrayList<Card>(15);
        for (int slot = 1; slot < 16; ++slot) {
            List<CardInfo> availableCards = this.boosterMap.get(slot);
            int printSheetCardNumber = RandomUtil.nextInt((int)availableCards.size());
            Card chosenCard = availableCards.get(printSheetCardNumber).createCard();
            booster.add(chosenCard);
        }
        return booster;
    }

    private void initBoosterMap() {
        for (int i = 1; i < 16; ++i) {
            this.boosterMap.put(i, new ArrayList(121));
        }
        this.addSlot1whiteA(this.boosterMap.get(1));
        this.addSlot2whiteB(this.boosterMap.get(2));
        this.addSlot3blueA(this.boosterMap.get(3));
        this.addSlot4blueB(this.boosterMap.get(4));
        this.addSlot5blackA(this.boosterMap.get(5));
        this.addSlot6blackB(this.boosterMap.get(6));
        this.addSlot7redA(this.boosterMap.get(7));
        this.addSlot8redB(this.boosterMap.get(8));
        this.addSlot9greenA(this.boosterMap.get(9));
        this.addSlot10greenB(this.boosterMap.get(10));
        this.addSlot11multicolored(this.boosterMap.get(11));
        this.addSlot12colorless(this.boosterMap.get(12));
        this.addSlot13oldFrame(this.boosterMap.get(13));
        this.addSlot14rare(this.boosterMap.get(14));
        this.addSlot15foil(this.boosterMap.get(15));
    }

    private void addSlot1whiteA(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Abzan Falconer", (String)"KTK", (String)"2");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Abzan Runemark", (String)"FRF", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Acrobatic Maneuver", (String)"KLD", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Affa Protector", (String)"OGW", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ainok Bond-Kin", (String)"KTK", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alley Evasion", (String)"AER", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angelic Purge", (String)"SOI", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angelsong", (String)"DDC", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Apostle's Blessing", (String)"MM2", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arrester's Zeal", (String)"RNA", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Artful Maneuver", (String)"DTK", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aura of Silence", (String)"C15", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bartered Cow", (String)"ELD", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bonds of Faith", (String)"DDQ", (String)"2");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Borrowed Grace", (String)"EMN", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bulwark Giant", (String)"WAR", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caravan Escort", (String)"DDP", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caught in the Brights", (String)"AER", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Celestial Crusader", (String)"C14", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Celestial Flare", (String)"ORI", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Center Soul", (String)"DTK", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cliffside Lookout", (String)"BFZ", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Conviction", (String)"AER", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Countless Gears Renegade", (String)"AER", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Court Street Denizen", (String)"DDO", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crib Swap", (String)"C18", (String)"65");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Danitha Capashen, Paragon", (String)"DOM", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Daring Skyjek", (String)"GK1", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Decommission", (String)"AER", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Defiant Strike", (String)"WAR", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desperate Sentry", (String)"EMN", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Devilthorn Fox", (String)"SOI", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Disposal Mummy", (String)"HOU", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Divine Favor", (String)"M15", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon's Eye Sentry", (String)"DTK", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon's Presence", (String)"GS1", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eddytrail Hawk", (String)"KLD", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Enduring Victory", (String)"DTK", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Enlightened Ascetic", (String)"ORI", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ephemeral Shields", (String)"M15", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ephemerate", (String)"MH1", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Excoriate", (String)"E01", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Expose Evil", (String)"SOI", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eyes in the Skies", (String)"MM3", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faith's Fetters", (String)"UMA", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Feat of Resistance", (String)"KTK", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Felidar Umbra", (String)"PCA", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Firehoof Cavalry", (String)"KTK", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghostblade Eidolon", (String)"C15", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gift of Estates", (String)"C14", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glaring Aegis", (String)"DTK", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glint-Sleeve Artisan", (String)"KLD", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"God-Pharaoh's Faithful", (String)"HOU", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grasp of the Hieromancer", (String)"E01", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gust Walker", (String)"AKH", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gustcloak Skirmisher", (String)"DDO", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Healing Hands", (String)"ORI", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hyena Umbra", (String)"UMA", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Infantry Veteran", (String)"DDN", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inquisitor's Ox", (String)"SOI", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Isolation Zone", (String)"OGW", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of Old Benalia", (String)"MH1", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of Sorrows", (String)"RNA", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Skyfisher", (String)"DDO", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Leonin Relic-Warder", (String)"C17", (String)"65");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightform", (String)"C18", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lone Missionary", (String)"DDN", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lonesome Unicorn", (String)"ELD", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lotus-Eye Mystics", (String)"UMA", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Loxodon Partisan", (String)"DDO", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mardu Hordechief", (String)"KTK", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Marked by Honor", (String)"M15", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Meditation Puzzle", (String)"M15", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mortal's Ardor", (String)"DDO", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mother of Runes", (String)"DDO", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ninth Bridge Patrol", (String)"KLD", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ondu Greathorn", (String)"BFZ", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ondu War Cleric", (String)"OGW", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Oreskos Swiftclaw", (String)"M15", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Oust", (String)"DDP", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Palace Jailer", (String)"CN2", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Path to Exile", (String)"E02", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Peace of Mind", (String)"EMN", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prowling Caracal", (String)"RNA", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Resurrection", (String)"UMA", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhet-Crop Spearmaster", (String)"AKH", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Righteous Cause", (String)"CMA", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Savannah Lions", (String)"A25", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Searing Light", (String)"OGW", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Serra's Embrace", (String)"DDC", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sheer Drop", (String)"BFZ", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shining Aerosaur", (String)"XLN", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shining Armor", (String)"ELD", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Siegecraft", (String)"KTK", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skymarcher Aspirant", (String)"RIX", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skyspear Cavalry", (String)"UMA", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Snubhorn Sentry", (String)"RIX", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul Parry", (String)"DDO", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul Summons", (String)"FRF", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul-Strike Technique", (String)"MH1", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soulmender", (String)"M15", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sparring Mummy", (String)"AKH", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spectral Gateguards", (String)"DDQ", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stave Off", (String)"DDN", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Steadfast Sentinel", (String)"HOU", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stone Haven Medic", (String)"BFZ", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Suppression Bonds", (String)"ORI", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Survive the Night", (String)"SOI", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Territorial Hammerskull", (String)"XLN", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thraben Inspector", (String)"SOI", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thraben Standard Bearer", (String)"EMN", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Topan Freeblade", (String)"ORI", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Veteran Swordsmith", (String)"DDO", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Village Bell-Ringer", (String)"DDQ", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Voice of the Provinces", (String)"DDQ", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wall of One Thousand Cuts", (String)"MH1", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wandering Champion", (String)"UMA", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"War Behemoth", (String)"KTK", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Windborne Charge", (String)"CN2", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wing Shards", (String)"IMA", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Winged Shepherd", (String)"AKH", (String)"39");
    }

    private void addSlot2whiteB(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Adanto Vanguard", (String)"XLN", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ajani's Pridemate", (String)"WAR", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angel of Mercy", (String)"IMA", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angel of Renewal", (String)"BFZ", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angelic Gift", (String)"BBD", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arrest", (String)"MM2", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aven Battle Priest", (String)"ORI", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aven Sentry", (String)"DOM", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ballynock Cohort", (String)"EMA", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Battle Mastery", (String)"BBD", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Benevolent Ancestor", (String)"IMA", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blade Instructor", (String)"GRN", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blessed Spirits", (String)"ORI", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Built to Last", (String)"KLD", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Candlelight Vigil", (String)"GRN", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cartouche of Solidarity", (String)"AKH", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cast Out", (String)"AKH", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cathar's Companion", (String)"SOI", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Champion of Arashin", (String)"DTK", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Charge", (String)"DOM", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cloudshift", (String)"A25", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coalition Honor Guard", (String)"EMA", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Collar the Culprit", (String)"GRN", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Congregate", (String)"M15", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Court Homunculus", (String)"MM2", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Darksteel Mutation", (String)"CMA", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dauntless Cathar", (String)"SOI", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dawnglare Invoker", (String)"C15", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Disenchant", (String)"M20", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dismantling Blow", (String)"MH1", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Djeru's Renunciation", (String)"HOU", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Djeru's Resolve", (String)"AKH", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Doomed Traveler", (String)"CN2", (String)"83");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Bell Monk", (String)"IMA", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Emerge Unscathed", (String)"IMA", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Encampment Keeper", (String)"XLN", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Encircling Fissure", (String)"BFZ", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Excavation Elephant", (String)"DOM", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Expedition Raptor", (String)"BBD", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Exultant Skymarcher", (String)"RIX", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faithbearer Paladin", (String)"EMN", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Felidar Guardian", (String)"AER", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fencing Ace", (String)"A25", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fiend Hunter", (String)"CMA", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Forsake the Worldly", (String)"AKH", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fortify", (String)"MM2", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fragmentize", (String)"KLD", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Geist of the Moors", (String)"A25", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gideon's Lawkeeper", (String)"MM3", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gleam of Resistance", (String)"CN2", (String)"87");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gods Willing", (String)"UMA", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Great-Horn Krushok", (String)"FRF", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guided Strike", (String)"IMA", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Healer's Hawk", (String)"GRN", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Healing Grace", (String)"DOM", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Heavy Infantry", (String)"ORI", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Humble", (String)"EMA", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inspired Charge", (String)"M19", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Intrusive Packbeast", (String)"GRN", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Iona's Judgment", (String)"IMA", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jubilant Mascot", (String)"BBD", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of Cliffhaven", (String)"DDP", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of the Skyward Eye", (String)"A25", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of the Tusk", (String)"M19", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Bladewhirl", (String)"BFZ", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Firewalker", (String)"A25", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Hookmaster", (String)"EMA", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Sky Climber", (String)"OGW", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lieutenants of the Guard", (String)"CN2", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightwalker", (String)"BBD", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lingering Souls", (String)"MM3", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Looming Altisaur", (String)"XLN", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Loyal Sentry", (String)"A25", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lunarch Mantle", (String)"A25", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Midnight Guard", (String)"BBD", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Momentary Blink", (String)"MM3", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Moonlit Strider", (String)"MM2", (String)"27");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nyx-Fleece Ram", (String)"A25", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pacifism", (String)"M20", (String)"32");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Palace Sentinels", (String)"CN2", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Paladin of the Bloodstained", (String)"XLN", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Path of Peace", (String)"A25", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pegasus Courser", (String)"M19", (String)"32");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pentarch Ward", (String)"IMA", (String)"27");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pitfall Trap", (String)"MM3", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pressure Point", (String)"FRF", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Promise of Bunrei", (String)"A25", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rally the Peasants", (String)"EMA", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Raptor Companion", (String)"RIX", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Refurbish", (String)"KLD", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Renewed Faith", (String)"A25", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Retreat to Emeria", (String)"BFZ", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reviving Dose", (String)"CN2", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rootborn Defenses", (String)"MM3", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sacred Cat", (String)"AKH", (String)"27");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sanctum Gargoyle", (String)"C16", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sandstorm Charger", (String)"DTK", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seal of Cleansing", (String)"EMA", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seeker of the Way", (String)"KTK", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sensor Splicer", (String)"MM3", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seraph of the Suns", (String)"AKH", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Serra Disciple", (String)"DOM", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shoulder to Shoulder", (String)"BBD", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silverchase Fox", (String)"BBD", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skyhunter Skirmisher", (String)"MM2", (String)"32");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Slash of Talons", (String)"XLN", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul Warden", (String)"MM3", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stalwart Aven", (String)"IMA", (String)"32");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Star-Crowned Stag", (String)"M19", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sunlance", (String)"MM2", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sunrise Seeker", (String)"XLN", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Swords to Plowshares", (String)"C16", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Take Vengeance", (String)"M19", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tandem Tactics", (String)"BBD", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Terashi's Grasp", (String)"MM2", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unwavering Initiate", (String)"AKH", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wake the Reflections", (String)"MM3", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wall of Omens", (String)"EMA", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wild Griffin", (String)"CN2", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Youthful Knight", (String)"MM3", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zealous Strike", (String)"CN2", (String)"101");
    }

    private void addSlot3blueA(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Amass the Components", (String)"IMA", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Anticipate", (String)"M19", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Artificer's Assistant", (String)"DOM", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Augury Owl", (String)"PCA", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Befuddle", (String)"M19", (String)"309");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Benthic Giant", (String)"BBD", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Calculated Dismissal", (String)"ORI", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Call to Heel", (String)"BBD", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caller of Gales", (String)"CN2", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cancel", (String)"KTK", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Capture Sphere", (String)"GRN", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Catalog", (String)"SOI", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chart a Course", (String)"XLN", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chillbringer", (String)"RNA", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chronostutter", (String)"M15", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Circular Logic", (String)"UMA", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Clear the Mind", (String)"RNA", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cloak of Mists", (String)"GS1", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cloudkin Seer", (String)"M20", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Clutch of Currents", (String)"BFZ", (String)"72");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Compelling Argument", (String)"AKH", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Condescend", (String)"IMA", (String)"46");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Containment Membrane", (String)"OGW", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Contingency Plan", (String)"EMN", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Contradict", (String)"DTK", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crashing Tide", (String)"RIX", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crush Dissent", (String)"WAR", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Curio Vendor", (String)"KLD", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Daze", (String)"DD2", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Decision Paralysis", (String)"AKH", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deep Freeze", (String)"DOM", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dispel", (String)"BFZ", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Displace", (String)"EMN", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Drag Under", (String)"W17", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon's Eye Savants", (String)"KTK", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dreadwaters", (String)"ORI", (String)"56");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Embodiment of Spring", (String)"KTK", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ensoul Artifact", (String)"M15", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Everdream", (String)"MH1", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Failed Inspection", (String)"KLD", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flashfreeze", (String)"MM2", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fledgling Mawcor", (String)"DD2", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fleeting Distraction", (String)"CN2", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fogwalker", (String)"EMN", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Foil", (String)"UMA", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frantic Search", (String)"UMA", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frilled Sea Serpent", (String)"M19", (String)"56");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gaseous Form", (String)"EMA", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glint", (String)"DTK", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gone Missing", (String)"SOI", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grasp of Phantoms", (String)"MM3", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guard Gomazoa", (String)"PCA", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gurmag Drowner", (String)"DTK", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gush", (String)"DD2", (String)"27");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hightide Hermit", (String)"KLD", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hinterland Drake", (String)"AER", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Humongulus", (String)"RNA", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inkfathom Divers", (String)"DDT", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Invisibility", (String)"M15", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jeering Homunculus", (String)"CN2", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jeskai Sage", (String)"FRF", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kiora's Dambreaker", (String)"WAR", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Laboratory Brute", (String)"EMN", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Laboratory Maniac", (String)"UMA", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Labyrinth Guardian", (String)"AKH", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Messenger Jays", (String)"CN2", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Sculpt", (String)"M15", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mist Raven", (String)"DDQ", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mnemonic Wall", (String)"IMA", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Monastery Loremaster", (String)"DTK", (String)"63");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Murder of Crows", (String)"A25", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nagging Thoughts", (String)"SOI", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Niblis of Dusk", (String)"SOI", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nine-Tail White Fox", (String)"GS1", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ojutai's Breath", (String)"DTK", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Ingester", (String)"EMA", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pondering Mage", (String)"MH1", (String)"63");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Predict", (String)"C18", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Purple-Crystal Crab", (String)"GS1", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Refocus", (String)"FRF", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Riftwing Cloudskate", (String)"DD2", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"River Darter", (String)"RIX", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sailor of Means", (String)"RIX", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scroll Thief", (String)"DDT", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Send to Sleep", (String)"ORI", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shipwreck Looter", (String)"XLN", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silent Observer", (String)"SOI", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silvergill Adept", (String)"RIX", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Singing Bell Strike", (String)"KTK", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skaab Goliath", (String)"ORI", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skitter Eel", (String)"RNA", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sleep", (String)"M19", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Slipstream Eel", (String)"CM2", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Slither Blade", (String)"AKH", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sphinx's Tutelage", (String)"ORI", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stream of Thought", (String)"MH1", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Surrakar Banisher", (String)"DDO", (String)"43");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Syr Elenora, the Discerning", (String)"ELD", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thought Collapse", (String)"RNA", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thunder Drake", (String)"WAR", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tidal Warrior", (String)"DDT", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trail of Evidence", (String)"SOI", (String)"93");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Treasure Cruise", (String)"KTK", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Treasure Mage", (String)"DDU", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trinket Mage", (String)"DDU", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Turn Aside", (String)"EMN", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Uncomfortable Chill", (String)"M19", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wall of Frost", (String)"MM3", (String)"56");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Warden of Evos Isle", (String)"EMA", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Watercourser", (String)"BBD", (String)"137");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Weldfast Wingsmith", (String)"KLD", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Welkin Tern", (String)"GS1", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wind Drake", (String)"KLD", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wind Strider", (String)"XLN", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wind-Kin Raiders", (String)"AER", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Windcaller Aven", (String)"MH1", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wishcoin Crab", (String)"GRN", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wishful Merfolk", (String)"ELD", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wretched Gryff", (String)"EMN", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Write into Being", (String)"FRF", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Youthful Scholar", (String)"DTK", (String)"84");
    }

    private void addSlot4blueB(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Academy Journeymage", (String)"DOM", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aether Tradewinds", (String)"KLD", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aethersnipe", (String)"MM2", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Amphin Pathmage", (String)"M15", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arcane Denial", (String)"CMA", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Archaeomancer", (String)"C17", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Archetype of Imagination", (String)"C18", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Augur of Bolas", (String)"MM3", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bastion Inventor", (String)"AER", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bewilder", (String)"IMA", (String)"43");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blue Elemental Blast", (String)"A25", (String)"43");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Borrowing 100,000 Arrows", (String)"A25", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brainstorm", (String)"A25", (String)"46");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brilliant Spectrum", (String)"BFZ", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brine Elemental", (String)"A25", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cartouche of Knowledge", (String)"AKH", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Castaway's Despair", (String)"XLN", (String)"281");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Choking Tethers", (String)"A25", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Citywatch Sphinx", (String)"GRN", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Claustrophobia", (String)"DDT", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cloud Elemental", (String)"MM2", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cloudreader Sphinx", (String)"DOM", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Concentrate", (String)"E02", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Convolute", (String)"EMN", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coral Trickster", (String)"DDN", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coralhelm Guide", (String)"BBD", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Counterspell", (String)"A25", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Court Hussar", (String)"A25", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Curiosity", (String)"A25", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dazzling Lights", (String)"GRN", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deep Analysis", (String)"EMA", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Diminish", (String)"IMA", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dirgur Nemesis", (String)"DTK", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Distortion Strike", (String)"IMA", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Divination", (String)"M19", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Doorkeeper", (String)"IMA", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dream Cache", (String)"C18", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dream Twist", (String)"EMA", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eel Umbra", (String)"C18", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Enlightened Maniac", (String)"EMN", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Errant Ephemeron", (String)"DD2", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Essence Scatter", (String)"M19", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Exclude", (String)"MH1", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fact or Fiction", (String)"CM2", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faerie Invaders", (String)"DDN", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faerie Mechanist", (String)"DDU", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fascination", (String)"FRF", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fathom Seer", (String)"C14", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fog Bank", (String)"BBD", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Forbidden Alchemy", (String)"MM3", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frost Lynx", (String)"BBD", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghost Ship", (String)"A25", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glacial Crasher", (String)"M15", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hieroglyphic Illumination", (String)"AKH", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Horseshoe Crab", (String)"A25", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Impulse", (String)"BBD", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ior Ruin Expedition", (String)"E01", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jace's Phantasm", (String)"IMA", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jwar Isle Avenger", (String)"OGW", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lay Claim", (String)"AKH", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Leapfrog", (String)"GRN", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mahamoti Djinn", (String)"IMA", (String)"64");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Man-o'-War", (String)"A25", (String)"64");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mana Leak", (String)"DDN", (String)"64");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maximize Altitude", (String)"GRN", (String)"43");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Memory Lapse", (String)"EMA", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Merfolk Looter", (String)"DDT", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Metallic Rebuke", (String)"AER", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mulldrifter", (String)"CM2", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mystic of the Hidden Way", (String)"A25", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mystical Teachings", (String)"MM3", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Negate", (String)"RIX", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ninja of the Deep Hours", (String)"C18", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ojutai Interceptor", (String)"DTK", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Omenspeaker", (String)"BBD", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Opportunity", (String)"C17", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Opt", (String)"DOM", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Peel from Reality", (String)"DDO", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phantasmal Bear", (String)"A25", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Portent", (String)"C18", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Preordain", (String)"C15", (String)"101");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prodigal Sorcerer", (String)"EMA", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Propaganda", (String)"C16", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prosperous Pirates", (String)"XLN", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Repulse", (String)"CN2", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Retraction Helix", (String)"A25", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ringwarden Owl", (String)"ORI", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"River Serpent", (String)"AKH", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Riverwheel Aerialists", (String)"IMA", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sage of Lat-Nam", (String)"DOM", (String)"64");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sea Gate Oracle", (String)"C17", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sealock Monster", (String)"DDO", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Secrets of the Golden City", (String)"RIX", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shaper Parasite", (String)"C14", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shimmerscale Drake", (String)"AKH", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sigiled Starfish", (String)"ORI", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skittering Crustacean", (String)"CN2", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Snap", (String)"DDS", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Snapping Drake", (String)"M19", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Somber Hoverguard", (String)"MM2", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spire Monitor", (String)"MM3", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Steady Progress", (String)"MM2", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stitched Drake", (String)"DDQ", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Storm Sculptor", (String)"XLN", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Strategic Planning", (String)"HOU", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Syncopate", (String)"DOM", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tandem Lookout", (String)"MM3", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Temporal Fissure", (String)"DDS", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornwind Faeries", (String)"CMA", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thought Scour", (String)"IMA", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thoughtcast", (String)"MM2", (String)"64");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thrummingbird", (String)"CM2", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tidal Wave", (String)"EMA", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Totally Lost", (String)"BBD", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Treasure Hunt", (String)"C18", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Triton Tactics", (String)"DDT", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vapor Snag", (String)"MM2", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vigean Graftmage", (String)"MM2", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wave-Wing Elemental", (String)"BFZ", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Whiplash Trap", (String)"DDN", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Windrider Eel", (String)"E01", (String)"30");
    }

    private void addSlot5blackA(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aid the Fallen", (String)"WAR", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alesha's Vanguard", (String)"FRF", (String)"60");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alley Strangler", (String)"AER", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ambitious Aetherborn", (String)"KLD", (String)"72");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancestral Vengeance", (String)"FRF", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Annihilate", (String)"EMA", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bala Ged Scorpion", (String)"IMA", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bitter Revelation", (String)"KTK", (String)"65");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bladebrand", (String)"M20", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blighted Bat", (String)"AKH", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blistergrub", (String)"DDR", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bone Splinters", (String)"M20", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boon of Emrakul", (String)"EMN", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Breeding Pit", (String)"DDC", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Butcher's Glee", (String)"IMA", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cabal Therapy", (String)"EMA", (String)"83");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cackling Imp", (String)"DDC", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cadaver Imp", (String)"DDR", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Catacomb Slug", (String)"ORI", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Certain Death", (String)"EMN", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coat with Venom", (String)"DTK", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Corpsehatch", (String)"DDP", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Covenant of Blood", (String)"M15", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crow of Dark Tidings", (String)"SOI", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dark Dabbling", (String)"ORI", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dark Withering", (String)"C19", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Darkblast", (String)"GK1", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dead Reveler", (String)"IMA", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deadeye Tormentor", (String)"XLN", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Defeat", (String)"DTK", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Demon's Grasp", (String)"BFZ", (String)"108");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Demonic Tutor", (String)"DDC", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Demonic Vigor", (String)"DOM", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dismember", (String)"MM2", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Disowned Ancestor", (String)"KTK", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Doomed Dissenter", (String)"AKH", (String)"87");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Douse in Gloom", (String)"FRF", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dread Return", (String)"DDQ", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dregscape Zombie", (String)"DDN", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dukhara Scavenger", (String)"KLD", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dune Beetle", (String)"AKH", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Duress", (String)"EMA", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Farbog Revenant", (String)"SOI", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fetid Imp", (String)"ORI", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"First-Sphere Gargantua", (String)"MH1", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flesh to Dust", (String)"ORI", (String)"280");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fretwork Colony", (String)"KLD", (String)"83");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Genju of the Fens", (String)"DDD", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghoulcaller's Accomplice", (String)"SOI", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grasping Scoundrel", (String)"RIX", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gravepurge", (String)"DTK", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grim Discovery", (String)"DDR", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hideous End", (String)"DDR", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Induce Despair", (String)"DDP", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Infernal Scarring", (String)"ORI", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Infest", (String)"CN2", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Instill Infection", (String)"MM2", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kalastria Nightwatch", (String)"BFZ", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krumar Bond-Kin", (String)"KTK", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lazotep Behemoth", (String)"WAR", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Macabre Waltz", (String)"SOI", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Marauding Boneslasher", (String)"HOU", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mark of the Vampire", (String)"UMA", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Marsh Hulk", (String)"DTK", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Merciless Resolve", (String)"SOI", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Miasmic Mummy", (String)"AKH", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Rake", (String)"MH1", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mire's Malice", (String)"BFZ", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Murder", (String)"M20", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Murderous Compulsion", (String)"SOI", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nantuko Husk", (String)"ORI", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Never Happened", (String)"GRN", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nirkana Assassin", (String)"BFZ", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Plaguecrafter", (String)"GRN", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prowling Pangolin", (String)"EMA", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rakshasa's Secret", (String)"KTK", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Read the Bones", (String)"DDP", (String)"56");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reaper of Night", (String)"ELD", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reassembling Skeleton", (String)"M19", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reckless Imp", (String)"DTK", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reckless Spite", (String)"E01", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Returned Centaur", (String)"ORI", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Revenant", (String)"ORI", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rite of the Serpent", (String)"KTK", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ruin Rat", (String)"HOU", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scrounger of Souls", (String)"HOU", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sengir Vampire", (String)"W17", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shambling Attendants", (String)"KTK", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shambling Goblin", (String)"DTK", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shriekmaw", (String)"CMA", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silumgar Butcher", (String)"DTK", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skeleton Archer", (String)"M19", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stab Wound", (String)"M15", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stallion of Ashmouth", (String)"SOI", (String)"136");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stinkweed Imp", (String)"GK1", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stromkirk Patrol", (String)"CN2", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Subtle Strike", (String)"KLD", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sultai Runemark", (String)"FRF", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tar Snare", (String)"OGW", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thallid Omnivore", (String)"DOM", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"The Eldest Reborn", (String)"DOM", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornbow Archer", (String)"ORI", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thraben Foulbloods", (String)"EMN", (String)"108");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Torment of Venom", (String)"HOU", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Touch of Moonglove", (String)"ORI", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Twins of Maurer Estate", (String)"SOI", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Undercity's Embrace", (String)"RNA", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Untamed Hunger", (String)"OGW", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unyielding Krumar", (String)"KTK", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vampire Champion", (String)"RIX", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vampire Envoy", (String)"OGW", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vampire Nighthawk", (String)"E02", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vessel of Malignity", (String)"SOI", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Voracious Null", (String)"BFZ", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vraska's Finisher", (String)"WAR", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Walk the Plank", (String)"XLN", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Warteye Witch", (String)"MH1", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Weight of the Underworld", (String)"ORI", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Weirded Vampire", (String)"EMN", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yargle, Glutton of Urborg", (String)"DOM", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zulaport Chainmage", (String)"OGW", (String)"93");
    }

    private void addSlot6blackB(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Absorb Vis", (String)"CN2", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Accursed Spirit", (String)"M15", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Altar's Reap", (String)"DDR", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Animate Dead", (String)"EMA", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Baleful Ammit", (String)"AKH", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Balustrade Spy", (String)"IMA", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bartizan Bats", (String)"GRN", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Black Cat", (String)"M15", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blessing of Belzenlok", (String)"DOM", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blightsoil Druid", (String)"EMA", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blood Artist", (String)"C17", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodrite Invoker", (String)"DDP", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caligo Skin-Witch", (String)"DOM", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Carrion Feeder", (String)"MH1", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Carrion Imp", (String)"RNA", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Catacomb Crocodile", (String)"RNA", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caustic Tar", (String)"A25", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Child of Night", (String)"IMA", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Costly Plunder", (String)"XLN", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cower in Fear", (String)"MM3", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crippling Blight", (String)"M15", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cursed Minotaur", (String)"AKH", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Daring Demolition", (String)"AER", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dark Ritual", (String)"A25", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deadbridge Shaman", (String)"EMA", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Death Denied", (String)"MM2", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desperate Castaways", (String)"XLN", (String)"101");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Diabolic Edict", (String)"A25", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Die Young", (String)"KLD", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dinosaur Hunter", (String)"RIX", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dirge of Dread", (String)"A25", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dread Drone", (String)"MM2", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dreadbringer Lampads", (String)"C15", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Driver of the Dead", (String)"CN2", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Drudge Sentinel", (String)"DOM", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dusk Charger", (String)"RIX", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dusk Legion Zealot", (String)"RIX", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Epicure of Blood", (String)"M19", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Erg Raiders", (String)"A25", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eternal Thirst", (String)"IMA", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Evincar's Justice", (String)"CMA", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Executioner's Capsule", (String)"C16", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eyeblight's Ending", (String)"EMA", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fallen Angel", (String)"A25", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fatal Push", (String)"AER", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fen Hauler", (String)"AER", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Feral Abomination", (String)"DOM", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Festercreep", (String)"CM2", (String)"63");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Festering Newt", (String)"IMA", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fill with Fright", (String)"BBD", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fungal Infection", (String)"DOM", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghostly Changeling", (String)"MM2", (String)"83");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gifted Aetherborn", (String)"AER", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Go for the Throat", (String)"C17", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gravedigger", (String)"CM2", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gray Merchant of Asphodel", (String)"C14", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grim Affliction", (String)"MM2", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grixis Slavedriver", (String)"MM3", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grotesque Mutation", (String)"BBD", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gruesome Fate", (String)"RIX", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gurmag Angler", (String)"UMA", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hired Blade", (String)"M19", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hound of the Farbogs", (String)"SOI", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Innocent Blood", (String)"EMA", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inquisition of Kozilek", (String)"MM3", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lawless Broker", (String)"KLD", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lethal Sting", (String)"HOU", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lord of the Accursed", (String)"AKH", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"March of the Drowned", (String)"XLN", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mephitic Vapors", (String)"GRN", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Rot", (String)"W16", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Moment of Craving", (String)"RIX", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nameless Inversion", (String)"MM2", (String)"87");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Night's Whisper", (String)"EMA", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Noxious Dragon", (String)"FRF", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Okiba-Gang Shinobi", (String)"PCA", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Painful Lesson", (String)"AKH", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Rager", (String)"CMA", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Reclamation", (String)"C15", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pit Keeper", (String)"MM3", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Plague Wight", (String)"RNA", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Plagued Rusalka", (String)"MM2", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prakhata Club Security", (String)"KLD", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Queen's Agent", (String)"XLN", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Quest for the Gravelord", (String)"BBD", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rabid Bloodsucker", (String)"ORI", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rakdos Drake", (String)"IMA", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ravenous Chupacabra", (String)"RIX", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Recover", (String)"MM3", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Renegade Demon", (String)"DDR", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Renegade's Getaway", (String)"AER", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rotfeaster Maggot", (String)"M15", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scarab Feast", (String)"AKH", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scuttling Death", (String)"MM2", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seal of Doom", (String)"C15", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shadowcloak Vampire", (String)"M15", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skeletal Scrying", (String)"C14", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skulking Ghost", (String)"EMA", (String)"107");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Smiting Helix", (String)"MH1", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spreading Rot", (String)"XLN", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Street Wraith", (String)"A25", (String)"108");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tavern Swindler", (String)"BBD", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tendrils of Corruption", (String)"C14", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thorn of the Black Rose", (String)"CN2", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tidy Conclusion", (String)"KLD", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tragic Slip", (String)"C14", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trespasser's Curse", (String)"AKH", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trial of Ambition", (String)"AKH", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Typhoid Rats", (String)"M15", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unburden", (String)"AKH", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Urborg Uprising", (String)"EMA", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vampire Hexmage", (String)"C14", (String)"168");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vampire Lacerator", (String)"A25", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Virulent Swipe", (String)"IMA", (String)"113");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wake of Vultures", (String)"EMA", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Walking Corpse", (String)"M19", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wander in Death", (String)"AKH", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wight of Precinct Six", (String)"C16", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Will-o'-the-Wisp", (String)"A25", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Windgrace Acolyte", (String)"DOM", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wrench Mind", (String)"IMA", (String)"115");
    }

    private void addSlot7redA(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Act on Impulse", (String)"M15", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ainok Tracker", (String)"KTK", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alchemist's Greeting", (String)"EMN", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancient Grudge", (String)"MM3", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arc Trail", (String)"PCA", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arrow Storm", (String)"KTK", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Azra Bladeseeker", (String)"BBD", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Balduvian Horde", (String)"A25", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Barrage of Boulders", (String)"KTK", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beetleback Chief", (String)"PCA", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bellows Lizard", (String)"ORI", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blastfire Bolt", (String)"M15", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blazing Volley", (String)"AKH", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blindblast", (String)"WAR", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blood Ogre", (String)"E01", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodfire Expert", (String)"KTK", (String)"101");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodlust Inciter", (String)"AKH", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodstone Goblin", (String)"DOM", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blow Your House Down", (String)"ELD", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bombard", (String)"GNT", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bomber Corps", (String)"GK1", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Borrowed Hostility", (String)"EMN", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brazen Buccaneers", (String)"XLN", (String)"134");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brazen Wolves", (String)"EMN", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bring Low", (String)"KTK", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brute Strength", (String)"DDT", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Built to Smash", (String)"KLD", (String)"108");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Burst Lightning", (String)"MM2", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Canyon Lurkers", (String)"KTK", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chandra's Pyrohelix", (String)"WAR", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Charging Monstrosaur", (String)"XLN", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cobblebrute", (String)"ORI", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crowd's Favor", (String)"M15", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crown-Hunter Hireling", (String)"CN2", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Curse of Opulence", (String)"C17", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Destructive Tampering", (String)"AER", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Direct Current", (String)"GRN", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Fodder", (String)"GNT", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dynacharge", (String)"MM3", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Erratic Explosion", (String)"PCA", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Expedite", (String)"BBD", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Falkenrath Reaver", (String)"W17", (String)"21");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fireball", (String)"IMA", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flame Jab", (String)"EMA", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Forge Devil", (String)"M15", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Foundry Street Denizen", (String)"M15", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frontline Rebel", (String)"AER", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Furnace Whelp", (String)"IMA", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Galvanic Blast", (String)"DDU", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Generator Servant", (String)"M15", (String)"143");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Geomancer's Gambit", (String)"MH1", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghitu Lavarunner", (String)"DOM", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Giant Spectacle", (String)"KLD", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Assault", (String)"MM3", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Bombardment", (String)"DDN", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Fireslinger", (String)"MM2", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Matron", (String)"MH1", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Roughrider", (String)"M15", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin War Paint", (String)"BFZ", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gore Swine", (String)"FRF", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gorehorn Minotaurs", (String)"E01", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Granitic Titan", (String)"HOU", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grapeshot", (String)"DDS", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gravitic Punch", (String)"GRN", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guttersnipe", (String)"IMA", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hammerhand", (String)"IMA", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hardened Berserker", (String)"DTK", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hyena Pack", (String)"AKH", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ill-Tempered Cyclops", (String)"CN2", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Impact Tremors", (String)"DTK", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Incorrigible Youths", (String)"SOI", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inferno Fist", (String)"M15", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Inferno Jet", (String)"HOU", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ingot Chewer", (String)"CM2", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Keldon Halberdier", (String)"IMA", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kiln Fiend", (String)"IMA", (String)"137");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krenko's Enforcer", (String)"M15", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Leaping Master", (String)"KTK", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Leopard-Spotted Jiao", (String)"GS1", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Madcap Skills", (String)"MM3", (String)"99");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mardu Warshrieker", (String)"KTK", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maximize Velocity", (String)"GRN", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Miner's Bane", (String)"M15", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mogg Flunkies", (String)"MM3", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Molten Rain", (String)"MM3", (String)"103");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Monastery Swiftspear", (String)"IMA", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ondu Champion", (String)"BFZ", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Outnumber", (String)"BFZ", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Price of Progress", (String)"EMA", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pyrotechnics", (String)"FRF", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Quakefoot Cyclops", (String)"MH1", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reckless Fireweaver", (String)"KLD", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reckless Wurm", (String)"UMA", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rivals' Duel", (String)"PCA", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ruinous Gremlin", (String)"KLD", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Samut's Sprint", (String)"WAR", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sarkhan's Rage", (String)"DTK", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Screamreach Brawler", (String)"DTK", (String)"155");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seismic Shift", (String)"DOM", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shattering Spree", (String)"GK1", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shenanigans", (String)"MH1", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Smelt", (String)"M19", (String)"158");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sparkmage Apprentice", (String)"DDN", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sparkspitter", (String)"UMA", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Staggershock", (String)"IMA", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stormblood Berserker", (String)"E01", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Swift Kick", (String)"KTK", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tectonic Rift", (String)"M19", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Temur Battle Rage", (String)"FRF", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thrill of Possibility", (String)"ELD", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tibalt's Rager", (String)"WAR", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Torch Courier", (String)"GRN", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Valakut Invoker", (String)"BFZ", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Valakut Predator", (String)"BFZ", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Valley Dasher", (String)"KTK", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vandalize", (String)"DTK", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Volcanic Dragon", (String)"M19", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Volcanic Rush", (String)"DTK", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wall of Fire", (String)"M15", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wayward Giant", (String)"KLD", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wojek Bodyguard", (String)"GRN", (String)"120");
    }

    private void addSlot8redB(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Act of Treason", (String)"RNA", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ahn-Crop Crasher", (String)"AKH", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Akroan Sergeant", (String)"ORI", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Anger", (String)"UMA", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Atarka Efreet", (String)"DTK", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Avarax", (String)"EMA", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Barging Sergeant", (String)"GRN", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Battle Rampart", (String)"BBD", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Battle-Rattle Shaman", (String)"E01", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blades of Velis Vel", (String)"MM2", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodmad Vampire", (String)"SOI", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blur of Blades", (String)"HOU", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boggart Brute", (String)"ORI", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boiling Earth", (String)"BFZ", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boulder Salvo", (String)"OGW", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Browbeat", (String)"A25", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cartouche of Zeal", (String)"AKH", (String)"124");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cathartic Reunion", (String)"KLD", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chandra's Revolution", (String)"AER", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chartooth Cougar", (String)"A25", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cinder Hellion", (String)"OGW", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cleansing Screech", (String)"GS1", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cosmotronic Wave", (String)"GRN", (String)"95");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crash Through", (String)"M19", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Curse of the Nightly Hunt", (String)"CM2", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Death by Dragons", (String)"CMA", (String)"80");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Defiant Ogre", (String)"FRF", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Demolish", (String)"XLN", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desert Cerodon", (String)"AKH", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desperate Ravings", (String)"C15", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Distemper of the Blood", (String)"EMN", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Breath", (String)"BBD", (String)"172");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Egg", (String)"IMA", (String)"124");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Whelp", (String)"CMA", (String)"81");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragonsoul Knight", (String)"MM2", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dual Shot", (String)"SOI", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Earth Elemental", (String)"BBD", (String)"174");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Emrakul's Hatcher", (String)"DDP", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Enthralling Victor", (String)"BBD", (String)"176");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faithless Looting", (String)"CM2", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fall of the Hammer", (String)"CM2", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fervent Strike", (String)"DOM", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fierce Invocation", (String)"FRF", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fiery Hellhound", (String)"ORI", (String)"284");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fiery Temper", (String)"SOI", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fire Elemental", (String)"M19", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Firebolt", (String)"DDS", (String)"37");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Firebrand Archer", (String)"HOU", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flametongue Kavu", (String)"E01", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flamewave Invoker", (String)"BBD", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fling", (String)"AKH", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frenzied Raptor", (String)"XLN", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frilled Deathspitter", (String)"RIX", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frontline Devastator", (String)"HOU", (String)"93");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fury Charm", (String)"IMA", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Genju of the Spires", (String)"A25", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Balloon Brigade", (String)"CN2", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Locksmith", (String)"GRN", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Motivator", (String)"M19", (String)"143");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Oriflamme", (String)"MH1", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Warchief", (String)"DOM", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gut Shot", (String)"MM2", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hanweir Lancer", (String)"MM3", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hijack", (String)"XLN", (String)"148");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hulking Devil", (String)"SOI", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Insolent Neonate", (String)"SOI", (String)"168");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jackal Pup", (String)"A25", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Keldon Overseer", (String)"DOM", (String)"134");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Khenra Scrapper", (String)"HOU", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kird Ape", (String)"EMA", (String)"137");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kolaghan Stormsinger", (String)"DTK", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krenko's Command", (String)"DDT", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Bolt", (String)"E01", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Javelin", (String)"ORI", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Shrieker", (String)"FRF", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Talons", (String)"BBD", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Magma Spray", (String)"AKH", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Makindi Sliderunner", (String)"BFZ", (String)"148");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mark of Mutiny", (String)"PCA", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mogg Fanatic", (String)"DD1", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mogg War Marshal", (String)"EMA", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mutiny", (String)"RIX", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nimble-Blade Khenra", (String)"AKH", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Orcish Cannonade", (String)"DDN", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Orcish Oriflamme", (String)"EMA", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pillage", (String)"A25", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prickleboar", (String)"ORI", (String)"158");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prophetic Ravings", (String)"EMN", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rampaging Cyclops", (String)"DOM", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Renegade Tactics", (String)"KLD", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Roast", (String)"DTK", (String)"151");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rolling Thunder", (String)"BFZ", (String)"154");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rubblebelt Maaka", (String)"MM3", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rummaging Goblin", (String)"XLN", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Run Amok", (String)"DOM", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rush of Adrenaline", (String)"SOI", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Salivating Gremlins", (String)"KLD", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seismic Stomp", (String)"EMA", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shatter", (String)"RIX", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shock", (String)"M19", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skirk Commando", (String)"A25", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skirk Prospector", (String)"DOM", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Smash to Smithereens", (String)"MM2", (String)"124");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sparktongue Dragon", (String)"M19", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spikeshot Goblin", (String)"A25", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sulfurous Blast", (String)"CMA", (String)"88");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Summit Prowler", (String)"DTK", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sun-Crowned Hunters", (String)"XLN", (String)"164");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Swashbuckling", (String)"XLN", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sweatworks Brawler", (String)"AER", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tarfire", (String)"DDT", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thresher Lizard", (String)"AKH", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Uncaged Fury", (String)"A25", (String)"155");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Undying Rage", (String)"EMA", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vent Sentinel", (String)"IMA", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vessel of Volatility", (String)"SOI", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Voldaren Duelist", (String)"SOI", (String)"191");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wildfire Emissary", (String)"EMA", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Young Pyromancer", (String)"DDS", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zada's Commando", (String)"OGW", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zealot of the God-Pharaoh", (String)"HOU", (String)"207");
    }

    private void addSlot9greenA(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Affectionate Indrik", (String)"GRN", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancestral Mask", (String)"EMA", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancient Brontodon", (String)"XLN", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arbor Armament", (String)"DOM", (String)"155");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beastbreaker of Bala Ged", (String)"DDP", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Become Immense", (String)"KTK", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blanchwood Armor", (String)"M19", (String)"169");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blastoderm", (String)"DDD", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Borderland Explorer", (String)"C18", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Briarhorn", (String)"DDR", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Broodhunter Wurm", (String)"BFZ", (String)"171");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Byway Courier", (String)"SOI", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Centaur Courser", (String)"M19", (String)"171");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Creeping Mold", (String)"KLD", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Destructor Dragon", (String)"FRF", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Domesticated Hydra", (String)"CN2", (String)"63");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon-Scarred Bear", (String)"DTK", (String)"183");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elemental Uprising", (String)"OGW", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elvish Fury", (String)"MH1", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eternal Witness", (String)"UMA", (String)"163");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Feral Prowler", (String)"HOU", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fierce Empath", (String)"DDU", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frontier Mastodon", (String)"FRF", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gaea's Blessing", (String)"DOM", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gaea's Protector", (String)"DOM", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gift of Growth", (String)"DOM", (String)"163");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glade Watcher", (String)"DTK", (String)"188");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grapple with the Past", (String)"C18", (String)"148");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greater Basilisk", (String)"IMA", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greater Sandwurm", (String)"AKH", (String)"168");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hamlet Captain", (String)"EMN", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hooded Brawler", (String)"AKH", (String)"173");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hooting Mandrills", (String)"KTK", (String)"137");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jungle Delver", (String)"XLN", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jungle Wayfinder", (String)"BBD", (String)"72");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kin-Tree Warden", (String)"KTK", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kraul Foragers", (String)"GRN", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krosan Druid", (String)"DOM", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lead by Example", (String)"BBD", (String)"205");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lead the Stampede", (String)"DDU", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lifespring Druid", (String)"BFZ", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lignify", (String)"DDD", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Llanowar Elves", (String)"M19", (String)"314");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Llanowar Empath", (String)"DDU", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lure", (String)"IMA", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mantle of Webs", (String)"ORI", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Map the Wastes", (String)"FRF", (String)"134");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mulch", (String)"CMA", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Natural Connection", (String)"DDR", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Naturalize", (String)"M19", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nature's Lore", (String)"DDD", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nest Invader", (String)"PCA", (String)"69");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nettle Sentinel", (String)"A25", (String)"182");
        MysteryBooster.addCardInfoToList(boosterList, (String)"New Horizons", (String)"XLN", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nimble Mongoose", (String)"EMA", (String)"179");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ondu Giant", (String)"PCA", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Oran-Rief Invoker", (String)"DDR", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Overgrown Armasaur", (String)"RIX", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pack's Favor", (String)"GRN", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Penumbra Spider", (String)"MM3", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pierce the Sky", (String)"DOM", (String)"176");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Plummet", (String)"RIX", (String)"143");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prey Upon", (String)"GRN", (String)"143");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prey's Vengeance", (String)"IMA", (String)"182");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pulse of Murasa", (String)"OGW", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Quiet Disrepair", (String)"PCA", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rampant Growth", (String)"DDS", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ranger's Guile", (String)"M15", (String)"193");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ravenous Leucrocota", (String)"CN2", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reclaim", (String)"ORI", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Revive", (String)"MM3", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhox Maulers", (String)"ORI", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Riparian Tiger", (String)"KLD", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Roar of the Wurm", (String)"DDS", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Root Out", (String)"SOI", (String)"224");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rosethorn Halberd", (String)"ELD", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Runeclaw Bear", (String)"M15", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sagu Archer", (String)"KTK", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sakura-Tribe Elder", (String)"C18", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Saproling Migration", (String)"DOM", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Savage Punch", (String)"KTK", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seal of Strength", (String)"EMA", (String)"184");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Search for Tomorrow", (String)"IMA", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seek the Horizon", (String)"DDR", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Seek the Wilds", (String)"BFZ", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shape the Sands", (String)"DTK", (String)"205");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Siege Wurm", (String)"GRN", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silhana Ledgewalker", (String)"PCA", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Silkweaver Elite", (String)"AER", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Snake Umbra", (String)"C18", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Snapping Sailback", (String)"XLN", (String)"208");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spider Spawning", (String)"CMA", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stoic Builder", (String)"SOI", (String)"231");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Strength in Numbers", (String)"MM3", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sylvan Bounty", (String)"E01", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tajuru Pathwarden", (String)"OGW", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Take Down", (String)"KLD", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Talons of Wildwood", (String)"M19", (String)"202");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Territorial Baloth", (String)"DDP", (String)"24");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornhide Wolves", (String)"M19", (String)"204");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornweald Archer", (String)"CMA", (String)"154");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thrive", (String)"MM2", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Timberwatch Elf", (String)"EMA", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Time to Feed", (String)"DDO", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Titanic Growth", (String)"M19", (String)"205");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tukatongue Thallid", (String)"PCA", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Turntimber Basilisk", (String)"E01", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vastwood Gorger", (String)"ORI", (String)"204");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Watcher in the Web", (String)"SOI", (String)"239");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wellwisher", (String)"CMA", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wild Growth", (String)"C18", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wild Mongrel", (String)"DDD", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wildsize", (String)"IMA", (String)"191");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wolfkin Bond", (String)"EMN", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Woodborn Behemoth", (String)"E01", (String)"79");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Woolly Loxodon", (String)"KTK", (String)"158");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wren's Run Vanquisher", (String)"DD1", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yavimaya Elder", (String)"C18", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yavimaya Sapherd", (String)"DOM", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yeva's Forcemage", (String)"ORI", (String)"208");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zendikar's Roil", (String)"ORI", (String)"209");
    }

    private void addSlot10greenB(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Abundant Growth", (String)"EMA", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Acidic Slime", (String)"C18", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Adventurous Impulse", (String)"DOM", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aerie Bowmasters", (String)"DTK", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aggressive Instinct", (String)"GS1", (String)"34");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aggressive Urge", (String)"RIX", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ainok Survivalist", (String)"DTK", (String)"172");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alpine Grizzly", (String)"KTK", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ambassador Oak", (String)"A25", (String)"158");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancient Stirrings", (String)"A25", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arachnus Web", (String)"MM3", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arbor Elf", (String)"A25", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aura Gnarlid", (String)"C18", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Avacyn's Pilgrim", (String)"MM3", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Backwoods Survivalists", (String)"EMN", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Baloth Gorger", (String)"DOM", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Basking Rootwalla", (String)"DDD", (String)"2");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beast Within", (String)"BBD", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beneath the Sands", (String)"HOU", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bestial Menace", (String)"MM2", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bitterblade Warrior", (String)"AKH", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bitterbow Sharpshooters", (String)"HOU", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blossom Dryad", (String)"XLN", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Borderland Ranger", (String)"E02", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bristling Boar", (String)"M19", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Broken Bond", (String)"DOM", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Canopy Spider", (String)"BBD", (String)"191");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Carnivorous Moss-Beast", (String)"M15", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caustic Caterpillar", (String)"ORI", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Charging Rhino", (String)"BBD", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Citanul Woodreaders", (String)"DDR", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Clip Wings", (String)"SOI", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Colossal Dreadmaw", (String)"XLN", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Combo Attack", (String)"BBD", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Commune with Nature", (String)"MM2", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Commune with the Gods", (String)"EMA", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Conifer Strider", (String)"DTK", (String)"179");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crop Rotation", (String)"DDR", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crossroads Consecrator", (String)"EMN", (String)"154");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crowned Ceratok", (String)"IMA", (String)"158");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crushing Canopy", (String)"GRN", (String)"126");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cultivate", (String)"C18", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Daggerback Basilisk", (String)"M19", (String)"174");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dawn's Reflection", (String)"C18", (String)"139");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Death-Hood Cobra", (String)"MM3", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desert Twister", (String)"CMA", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dissenter's Deliverance", (String)"AKH", (String)"164");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragonscale Boon", (String)"KTK", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Durkwood Baloth", (String)"IMA", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Earthen Arms", (String)"BFZ", (String)"172");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elephant Guide", (String)"EMA", (String)"163");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elves of Deep Shadow", (String)"GK1", (String)"56");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elvish Visionary", (String)"BBD", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elvish Warrior", (String)"DD1", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ember Weaver", (String)"A25", (String)"169");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Epic Confrontation", (String)"DTK", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Essence Warden", (String)"CMA", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Experiment One", (String)"C15", (String)"184");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Explore", (String)"DDO", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Explosive Vegetation", (String)"C18", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ezuri's Archers", (String)"DDU", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fade into Antiquity", (String)"CN2", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Farseek", (String)"C17", (String)"149");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Feed the Clan", (String)"KTK", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Feral Krushok", (String)"FRF", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ferocious Zheng", (String)"GS1", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fertile Ground", (String)"C18", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fog", (String)"EMA", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Formless Nurturing", (String)"FRF", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Giant Growth", (String)"BBD", (String)"200");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Giant Spider", (String)"AKH", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gift of Paradise", (String)"AKH", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gnarlid Pack", (String)"MM2", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grazing Gladehart", (String)"DDP", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greenwood Sentinel", (String)"M19", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Groundswell", (String)"DDP", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guardian Shield-Bearer", (String)"DTK", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hardy Veteran", (String)"RIX", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Harmonize", (String)"C17", (String)"151");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Harrow", (String)"C18", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hunt the Weak", (String)"RIX", (String)"133");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hunter's Ambush", (String)"M15", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Imperious Perfect", (String)"CMA", (String)"118");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Invigorate", (String)"A25", (String)"173");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ivy Lane Denizen", (String)"DDU", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kavu Climber", (String)"A25", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kavu Primarch", (String)"MM2", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Khalni Heart Expedition", (String)"C18", (String)"154");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kozilek's Predator", (String)"MM2", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kraul Warrior", (String)"BBD", (String)"204");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krosan Tusker", (String)"DDU", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Larger Than Life", (String)"KLD", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lay of the Land", (String)"CN2", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Longshot Squad", (String)"KTK", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Manglehorn", (String)"AKH", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Might of the Masses", (String)"ORI", (String)"188");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nature's Claim", (String)"IMA", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Oakgnarl Warrior", (String)"DDR", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Overgrown Battlement", (String)"IMA", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Overrun", (String)"CMA", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Peema Outrider", (String)"KLD", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pelakka Wurm", (String)"MM2", (String)"154");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pinion Feast", (String)"DTK", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pouncing Cheetah", (String)"AKH", (String)"179");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Priest of Titania", (String)"C14", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rain of Thorns", (String)"C17", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rancor", (String)"A25", (String)"186");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reclaiming Vines", (String)"BFZ", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Regrowth", (String)"A25", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Relic Crush", (String)"CM2", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Return to the Earth", (String)"BBD", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Roots", (String)"EMA", (String)"183");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scatter the Seeds", (String)"GK1", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stalking Tiger", (String)"W17", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sylvan Scrying", (String)"BFZ", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tajuru Warcaller", (String)"BFZ", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Terrain Elemental", (String)"KLD", (String)"272");
        MysteryBooster.addCardInfoToList(boosterList, (String)"The Crowd Goes Wild", (String)"BBD", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornscape Battlemage", (String)"MM3", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thrashing Brontodon", (String)"RIX", (String)"148");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Venom Sliver", (String)"M15", (String)"205");
    }

    private void addSlot11multicolored(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Abzan Charm", (String)"C16", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Abzan Guide", (String)"KTK", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Agony Warp", (String)"MM3", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Akroan Hoplite", (String)"CN2", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Armadillo Cloak", (String)"EMA", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Armament Corps", (String)"KTK", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Azorius Charm", (String)"IMA", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Azra Oddsmaker", (String)"BBD", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Baleful Strix", (String)"PCA", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Baloth Null", (String)"A25", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bear's Companion", (String)"KTK", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Belligerent Brontodon", (String)"XLN", (String)"218");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bituminous Blast", (String)"PCA", (String)"83");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bladewing the Risen", (String)"IMA", (String)"193");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blightning", (String)"A25", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloodbraid Elf", (String)"PCA", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boros Challenger", (String)"GRN", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bounding Krasis", (String)"ORI", (String)"212");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Call of the Nightwing", (String)"GK1", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Campaign of Vengeance", (String)"EMN", (String)"182");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cauldron Dance", (String)"C17", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Citadel Castellan", (String)"ORI", (String)"213");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Claim // Fame", (String)"HOU", (String)"150");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coiling Oracle", (String)"MM3", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Contraband Kingpin", (String)"KLD", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Corpsejack Menace", (String)"IMA", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crosis's Charm", (String)"C17", (String)"169");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cunning Breezedancer", (String)"DTK", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deathreap Ritual", (String)"C18", (String)"174");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deny Reality", (String)"PCA", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Draconic Disciple", (String)"M19", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Drana's Emissary", (String)"BFZ", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Engineered Might", (String)"KLD", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Esper Charm", (String)"C18", (String)"179");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ethercaste Knight", (String)"MM2", (String)"175");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ethereal Ambush", (String)"FRF", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Extract from Darkness", (String)"E01", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fire // Ice", (String)"UMA", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fires of Yavimaya", (String)"PCA", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flame-Kin Zealot", (String)"EMA", (String)"201");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fusion Elemental", (String)"PCA", (String)"93");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gelectrode", (String)"GK1", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghor-Clan Rampager", (String)"MM3", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Giantbaiting", (String)"MM3", (String)"208");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gift of Orzhova", (String)"MM3", (String)"209");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Deathraiders", (String)"DDN", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grim Contest", (String)"FRF", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gwyllion Hedge-Mage", (String)"CMA", (String)"201");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hammer Dropper", (String)"GRN", (String)"176");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hidden Stockpile", (String)"AER", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Highspire Mantis", (String)"KTK", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hypothesizzle", (String)"GRN", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Iroas's Champion", (String)"ORI", (String)"214");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Join Shields", (String)"GRN", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jungle Barrier", (String)"E02", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kathari Remnant", (String)"PCA", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kin-Tree Invocation", (String)"KTK", (String)"183");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kiora's Follower", (String)"DDO", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kiss of the Amesha", (String)"BBD", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lawmage's Binding", (String)"RNA", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Helix", (String)"GK1", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mardu Roughrider", (String)"KTK", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Martial Glory", (String)"GK1", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maverick Thopterist", (String)"C18", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mercurial Geists", (String)"EMN", (String)"186");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Migratory Route", (String)"CM2", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mistmeadow Witch", (String)"CMA", (String)"203");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mortify", (String)"C18", (String)"186");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Naya Charm", (String)"C16", (String)"214");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nucklavee", (String)"DDS", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Obelisk Spider", (String)"HOU", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ochran Assassin", (String)"GRN", (String)"194");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pillory of the Sleepless", (String)"A25", (String)"213");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Plaxcaster Frogling", (String)"MM2", (String)"184");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pollenbright Wings", (String)"GK1", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Putrefy", (String)"GK1", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Qasali Pridemage", (String)"C17", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Raff Capashen, Ship's Mage", (String)"DOM", (String)"202");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Raging Swordtooth", (String)"XLN", (String)"226");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reclusive Artificer", (String)"DDU", (String)"51");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reflector Mage", (String)"OGW", (String)"157");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhox War Monk", (String)"MM3", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Riptide Crab", (String)"BBD", (String)"228");
        MysteryBooster.addCardInfoToList(boosterList, (String)"River Hoopoe", (String)"HOU", (String)"143");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rosemane Centaur", (String)"GRN", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rosheen Meanderer", (String)"IMA", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Satyr Enchanter", (String)"M19", (String)"223");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Savage Twister", (String)"C18", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sedraxis Specter", (String)"MM3", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Selesnya Guildmage", (String)"GK1", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shambling Remains", (String)"DDN", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shardless Agent", (String)"PCA", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shipwreck Singer", (String)"CN2", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shrewd Hatchling", (String)"MM2", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skyward Eye Prophets", (String)"CMA", (String)"193");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Slave of Bolas", (String)"E01", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul Manipulation", (String)"MM3", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sprouting Thrinax", (String)"MM3", (String)"189");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stormchaser Chimera", (String)"CN2", (String)"207");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sultai Charm", (String)"KTK", (String)"204");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sultai Soothsayer", (String)"KTK", (String)"205");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tatyova, Benthic Druid", (String)"DOM", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Terminate", (String)"CMA", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thopter Foundry", (String)"C16", (String)"237");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thought Erasure", (String)"GRN", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tithe Drinker", (String)"C17", (String)"200");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tower Gargoyle", (String)"MM3", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Treacherous Terrain", (String)"C16", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Underworld Coinsmith", (String)"C15", (String)"237");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unflinching Courage", (String)"C18", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unlicensed Disintegration", (String)"KLD", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Urban Evolution", (String)"MM3", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vengeful Rebirth", (String)"MM2", (String)"188");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Warden of the Eye", (String)"KTK", (String)"212");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wayfaring Temple", (String)"MM3", (String)"202");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Weapons Trainer", (String)"OGW", (String)"160");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wee Dragonauts", (String)"GRN", (String)"214");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Winding Constrictor", (String)"AER", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Woolly Thoctar", (String)"MM3", (String)"203");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zealous Persecution", (String)"E02", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zhur-Taa Druid", (String)"C16", (String)"232");
    }

    private void addSlot12colorless(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aether Hub", (String)"KLD", (String)"242");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aether Spellbomb", (String)"MMA", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Akoum Refuge", (String)"CMA", (String)"238");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alchemist's Vial", (String)"ORI", (String)"220");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alloy Myr", (String)"MM2", (String)"201");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arcane Sanctum", (String)"C18", (String)"232");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Armillary Sphere", (String)"C17", (String)"203");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Artisan of Kozilek", (String)"CM2", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ash Barrens", (String)"CM2", (String)"235");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ashnod's Altar", (String)"EMA", (String)"218");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Benthic Infiltrator", (String)"BFZ", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blasted Landscape", (String)"CM2", (String)"238");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blighted Fen", (String)"BFZ", (String)"230");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blinding Souleater", (String)"MM2", (String)"202");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blossoming Sands", (String)"C18", (String)"237");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bojuka Bog", (String)"C18", (String)"238");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bomat Bazaar Barge", (String)"KLD", (String)"198");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bone Saw", (String)"OGW", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bottle Gnomes", (String)"CM2", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Breaker of Armies", (String)"BFZ", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Burnished Hart", (String)"C15", (String)"248");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Call the Scions", (String)"BFZ", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cathodion", (String)"CM2", (String)"179");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coldsteel Heart", (String)"CM2", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Consulate Dreadnought", (String)"AER", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Copper Carapace", (String)"MM2", (String)"205");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crumbling Necropolis", (String)"C17", (String)"244");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crystal Ball", (String)"C18", (String)"201");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crystal Chimes", (String)"C15", (String)"250");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Darksteel Citadel", (String)"MM2", (String)"238");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Diamond Mare", (String)"M19", (String)"231");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dismal Backwater", (String)"KTK", (String)"232");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dreadship Reef", (String)"CM2", (String)"247");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eldrazi Devastator", (String)"BFZ", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Emmessi Tome", (String)"EMA", (String)"221");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Etched Oracle", (String)"C16", (String)"252");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Evolving Wilds", (String)"C18", (String)"245");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Faerie Conclave", (String)"CMA", (String)"248");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Farmstead Gleaner", (String)"MH1", (String)"222");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Field of Ruin", (String)"XLN", (String)"254");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Filigree Familiar", (String)"GNT", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flayer Husk", (String)"PCA", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Forgotten Cave", (String)"C18", (String)"246");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Foundry Inspector", (String)"KLD", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fountain of Renewal", (String)"M19", (String)"235");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frogmite", (String)"MM2", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frontier Bivouac", (String)"C17", (String)"251");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gateway Plaza", (String)"GRN", (String)"247");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghost Quarter", (String)"CM2", (String)"253");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Burrows", (String)"DD1", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Graypelt Refuge", (String)"C17", (String)"253");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Great Furnace", (String)"C18", (String)"250");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gruul Signet", (String)"C16", (String)"256");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guardians of Meletis", (String)"ORI", (String)"228");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Heavy Arbalest", (String)"A25", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Herald's Horn", (String)"C17", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hexplate Golem", (String)"BBD", (String)"237");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hot Soup", (String)"M15", (String)"219");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Icy Manipulator", (String)"DOM", (String)"219");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Implement of Malice", (String)"AER", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Irontread Crusher", (String)"AER", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Juggernaut", (String)"BBD", (String)"238");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jungle Hollow", (String)"KTK", (String)"235");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jungle Shrine", (String)"C17", (String)"257");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kazandu Refuge", (String)"C18", (String)"261");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krosan Verge", (String)"C18", (String)"263");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Greaves", (String)"C19", (String)"217");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Loxodon Warhammer", (String)"C17", (String)"216");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mask of Memory", (String)"C14", (String)"249");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Meteorite", (String)"ORI", (String)"233");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Millikin", (String)"EMA", (String)"226");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Millstone", (String)"M19", (String)"242");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Stone", (String)"C18", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mishra's Bauble", (String)"IMA", (String)"221");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mishra's Factory", (String)"A25", (String)"242");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Moonglove Extract", (String)"IMA", (String)"222");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mortarpod", (String)"MM2", (String)"222");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Myr Retriever", (String)"CM2", (String)"203");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Myr Sire", (String)"CM2", (String)"204");
        MysteryBooster.addCardInfoToList(boosterList, (String)"New Benalia", (String)"C18", (String)"270");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ornithopter", (String)"M15", (String)"223");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Orzhov Basilica", (String)"C17", (String)"268");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Palladium Myr", (String)"CM2", (String)"207");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Peace Strider", (String)"BBD", (String)"243");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Perilous Myr", (String)"A25", (String)"227");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pilgrim's Eye", (String)"GNT", (String)"55");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Prophetic Prism", (String)"A25", (String)"229");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reliquary Tower", (String)"M19", (String)"254");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Renegade Map", (String)"AER", (String)"173");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhonas's Monument", (String)"AKH", (String)"236");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rogue's Passage", (String)"C17", (String)"272");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sandsteppe Citadel", (String)"CM2", (String)"264");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sandstone Oracle", (String)"CM2", (String)"213");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scoured Barrens", (String)"C18", (String)"276");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sejiri Refuge", (String)"C18", (String)"280");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Serrated Arrows", (String)"DDD", (String)"20");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Short Sword", (String)"DOM", (String)"229");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sigil of Valor", (String)"ORI", (String)"239");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Simic Locket", (String)"RNA", (String)"240");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skarrg, the Rage Pits", (String)"PCA", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skullclamp", (String)"C17", (String)"222");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Skyscanner", (String)"M19", (String)"245");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sol Ring", (String)"C18", (String)"222");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sorcerer's Broom", (String)"ELD", (String)"232");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sunset Pyramid", (String)"HOU", (String)"166");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Suspicious Bookcase", (String)"M19", (String)"246");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Swiftwater Cliffs", (String)"C18", (String)"284");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tectonic Edge", (String)"C14", (String)"313");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Temple of the False God", (String)"C18", (String)"285");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thornwood Falls", (String)"C18", (String)"287");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thought Vessel", (String)"CM2", (String)"224");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thran Dynamo", (String)"IMA", (String)"230");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thran Golem", (String)"PCA", (String)"114");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tormod's Crypt", (String)"C14", (String)"278");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trepanation Blade", (String)"IMA", (String)"231");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Unclaimed Territory", (String)"XLN", (String)"258");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Universal Automaton", (String)"MH1", (String)"235");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Universal Solvent", (String)"AER", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Whispersilk Cloak", (String)"PCA", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wirewood Lodge", (String)"DD1", (String)"26");
    }

    private void addSlot13oldFrame(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ana Sanctuary", (String)"APC", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancient Den", (String)"MRD", (String)"278");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ancient Ziggurat", (String)"CON", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angelic Destiny", (String)"M12", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Archangel", (String)"C13", (String)"5");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Asceticism", (String)"SOM", (String)"110");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Assemble the Legion", (String)"GTC", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Athreos, God of Passage", (String)"JOU", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aura Shards", (String)"CMD", (String)"182");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Avalanche Riders", (String)"ULG", (String)"74");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bear Cub", (String)"P02", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Belbe's Portal", (String)"NEM", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Black Knight", (String)"M10", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bloom Tender", (String)"EVE", (String)"66");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bonesplitter", (String)"MRD", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bow of Nylea", (String)"THS", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brimstone Dragon", (String)"P02", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Brimstone Mage", (String)"ROE", (String)"137");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cairn Wanderer", (String)"LRW", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Carpet of Flowers", (String)"USG", (String)"240");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Centaur Glade", (String)"ONS", (String)"251");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chancellor of the Annex", (String)"NPH", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chatter of the Squirrel", (String)"ODY", (String)"233");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chromatic Star", (String)"TSP", (String)"251");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Contagion Clasp", (String)"SOM", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Corrupted Conscience", (String)"MBS", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cragganwick Cremator", (String)"SHM", (String)"87");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crenellated Wall", (String)"MMQ", (String)"290");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Crystal Shard", (String)"MRD", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Darksteel Garrison", (String)"FUT", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dauthi Mindripper", (String)"TMP", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Defense of the Heart", (String)"ULG", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dictate of Erebos", (String)"JOU", (String)"65");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dolmen Gate", (String)"LRW", (String)"256");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dominus of Fealty", (String)"CMD", (String)"194");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Doomgape", (String)"DDJ", (String)"65");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Draco", (String)"PLS", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Broodmother", (String)"ARB", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragon Mask", (String)"VIS", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dungrove Elder", (String)"M12", (String)"171");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eater of Days", (String)"DST", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elixir of Immortality", (String)"M11", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Empyrial Armor", (String)"WTH", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Enchanted Evening", (String)"SHM", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Energy Field", (String)"USG", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Exsanguinate", (String)"SOM", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flameshot", (String)"PCY", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Floodgate", (String)"MIR", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Font of Mythos", (String)"CON", (String)"136");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ghitu War Cry", (String)"ULG", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gilt-Leaf Palace", (String)"LRW", (String)"268");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Game", (String)"PLS", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greater Gargadon", (String)"MMA", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guided Passage", (String)"APC", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Haakon, Stromgald Scourge", (String)"CSP", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hedron Crab", (String)"ZEN", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Helm of Awakening", (String)"VIS", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hunter of Eyeblights", (String)"LRW", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hurricane", (String)"10E", (String)"270");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hypnotic Specter", (String)"M10", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Impending Disaster", (String)"ULG", (String)"82");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Jushi Apprentice", (String)"CHK", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kaervek's Torch", (String)"MIR", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kargan Dragonlord", (String)"ROE", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knight of Dawn", (String)"TMP", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knollspine Dragon", (String)"SHM", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kor Chant", (String)"CNS", (String)"73");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kruphix, God of Horizons", (String)"JOU", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lashknife Barrier", (String)"PLS", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lotus Petal", (String)"TMP", (String)"294");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maelstrom Archangel", (String)"CON", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Magus of the Moat", (String)"FUT", (String)"12");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mana Tithe", (String)"PLC", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Manamorphose", (String)"SHM", (String)"211");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Martyr's Bond", (String)"CMD", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Martyr's Cause", (String)"ULG", (String)"13");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Master Transmuter", (String)"CON", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Meddling Mage", (String)"ARB", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mistform Shrieker", (String)"ONS", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nemesis of Reason", (String)"ARB", (String)"28");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Oracle of Nectars", (String)"SHM", (String)"233");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pathrazer of Ulamog", (String)"ROE", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Perish", (String)"TMP", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pestilence", (String)"USG", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phantasmal Dragon", (String)"DDM", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phantom Centaur", (String)"JUD", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Metamorph", (String)"NPH", (String)"42");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Soulgorger", (String)"CSP", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Purphoros, God of the Forge", (String)"THS", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Questing Phelddagrif", (String)"PLS", (String)"119");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rage Reflection", (String)"SHM", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Recoup", (String)"DDK", (String)"63");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Release the Ants", (String)"MOR", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhys the Redeemed", (String)"SHM", (String)"237");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhystic Study", (String)"PCY", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rishadan Footpad", (String)"MMQ", (String)"94");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rith, the Awakener", (String)"DDE", (String)"48");
        MysteryBooster.addCardInfoToList(boosterList, (String)"River Boa", (String)"ZEN", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sadistic Hypnotist", (String)"ODY", (String)"159");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sakashima the Impostor", (String)"SOK", (String)"53");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sapphire Charm", (String)"MIR", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shrouded Lore", (String)"PLC", (String)"91");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soothsaying", (String)"MMQ", (String)"104");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sorin Markov", (String)"ZEN", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Squirrel Wrangler", (String)"PCY", (String)"127");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thieving Magpie", (String)"UDS", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thrun, the Last Troll", (String)"MBS", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Time Sieve", (String)"ARB", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Timely Reinforcements", (String)"M12", (String)"40");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tinker", (String)"ULG", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tower of Eons", (String)"MRD", (String)"266");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Toxin Sliver", (String)"LGN", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Triumph of the Hordes", (String)"NPH", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Umbral Mantle", (String)"SHM", (String)"267");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Viashino Sandstalker", (String)"VIS", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Violent Ultimatum", (String)"ALA", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Volunteer Reserves", (String)"WTH", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wargate", (String)"ARB", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Weathered Wayfarer", (String)"ONS", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wild Nacatl", (String)"ALA", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yavimaya's Embrace", (String)"APC", (String)"127");
    }

    private void addSlot14rare(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Adorned Pouncer", (String)"HOU", (String)"2");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aetherflux Reservoir", (String)"KLD", (String)"192");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Akroan Horse", (String)"C16", (String)"241");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alesha, Who Smiles at Death", (String)"FRF", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alhammarret's Archive", (String)"ORI", (String)"221");
        MysteryBooster.addCardInfoToList(boosterList, (String)"All Is Dust", (String)"MM2", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aminatou's Augury", (String)"C18", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Angel of the Dire Hour", (String)"C14", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Anger of the Gods", (String)"IMA", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Animar, Soul of Elements", (String)"A25", (String)"196");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Approach of the Second Sun", (String)"AKH", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Arch of Orazca", (String)"RIX", (String)"185");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Basilisk Collar", (String)"MM3", (String)"216");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beacon of Immortality", (String)"E02", (String)"1");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Beastmaster Ascension", (String)"CMA", (String)"92");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Birds of Paradise", (String)"CN2", (String)"176");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Black Market", (String)"C17", (String)"98");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boompile", (String)"C16", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boros Reckoner", (String)"GK1", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Caged Sun", (String)"CM2", (String)"178");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Cauldron of Souls", (String)"CM2", (String)"180");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Champion of the Parish", (String)"DDQ", (String)"4");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chaos Warp", (String)"C17", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chasm Skulker", (String)"M15", (String)"46");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chromatic Lantern", (String)"GRN", (String)"233");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coat of Arms", (String)"DDS", (String)"58");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Collective Brutality", (String)"EMN", (String)"85");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Commit // Memory", (String)"AKH", (String)"211");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Courser of Kruphix", (String)"A25", (String)"164");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Coveted Jewel", (String)"C18", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Daretti, Scrap Savant", (String)"C14", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deadly Tempest", (String)"C15", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Debtors' Knell", (String)"GK2", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Decree of Justice", (String)"DDO", (String)"7");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Deepglow Skate", (String)"CM2", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Desolation Twin", (String)"BFZ", (String)"6");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dictate of Heliod", (String)"DDO", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Djinn of Wishes", (String)"C18", (String)"87");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Dragonlord Ojutai", (String)"DTK", (String)"219");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Drana, Kalastria Bloodchief", (String)"C17", (String)"112");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eldrazi Monument", (String)"CMA", (String)"216");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eldritch Evolution", (String)"EMN", (String)"155");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Elesh Norn, Grand Cenobite", (String)"IMA", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Evra, Halcyon Witness", (String)"DOM", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Expropriate", (String)"CN2", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fblthp, the Lost", (String)"WAR", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Felidar Sovereign", (String)"BFZ", (String)"26");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gideon Jura", (String)"E01", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Charbelcher", (String)"DDT", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Piledriver", (String)"ORI", (String)"151");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gonti, Lord of Luxury", (String)"KLD", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grasp of Fate", (String)"C15", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grave Titan", (String)"C14", (String)"145");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gravecrawler", (String)"DDQ", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greenbelt Rampager", (String)"AER", (String)"107");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hornet Nest", (String)"M15", (String)"177");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kiki-Jiki, Mirror Breaker", (String)"MM2", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kolaghan's Command", (String)"DTK", (String)"224");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Krenko, Mob Boss", (String)"DDT", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Liliana, Death's Majesty", (String)"AKH", (String)"97");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Living Death", (String)"A25", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mana Crypt", (String)"EMA", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Meandering Towershell", (String)"KTK", (String)"141");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Memory Erosion", (String)"CM2", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Meren of Clan Nel Toth", (String)"C15", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mimic Vat", (String)"C19", (String)"219");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Shatter", (String)"MM3", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Spring", (String)"DDT", (String)"14");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mirran Crusader", (String)"MM2", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mirror Entity", (String)"CMA", (String)"16");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Misdirection", (String)"DDT", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mizzix's Mastery", (String)"C15", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mycoloth", (String)"CMA", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mystic Confluence", (String)"BBD", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nighthowler", (String)"C15", (String)"129");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nin, the Pain Artist", (String)"C17", (String)"183");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nissa, Voice of Zendikar", (String)"OGW", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Odric, Lunarch Marshal", (String)"SOI", (String)"31");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Arena", (String)"CN2", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Phyrexian Plaguelord", (String)"CMA", (String)"61");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Precursor Golem", (String)"MM2", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Preyseizer Dragon", (String)"PCA", (String)"50");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Queen Marchesa", (String)"CN2", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reality Scramble", (String)"C18", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Recruiter of the Guard", (String)"CN2", (String)"22");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Release the Gremlins", (String)"AER", (String)"96");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Revel in Riches", (String)"XLN", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rune-Scarred Demon", (String)"IMA", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Savage Knuckleblade", (String)"KTK", (String)"197");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Selvala, Heart of the Wilds", (String)"CN2", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Serendib Efreet", (String)"EMA", (String)"70");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sewer Nemesis", (String)"CM2", (String)"75");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shamanic Revelation", (String)"FRF", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sliver Hivelord", (String)"M15", (String)"211");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Solemn Simulacrum", (String)"DDU", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spawning Grounds", (String)"C18", (String)"163");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Star of Extinction", (String)"XLN", (String)"161");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Steamflogger Boss", (String)"UST", (String)"93");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stunt Double", (String)"CN2", (String)"38");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sudden Demise", (String)"E01", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Supreme Verdict", (String)"IMA", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sword of the Animist", (String)"E01", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Talrand, Sky Summoner", (String)"DDS", (String)"11");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Taurean Mauler", (String)"CM2", (String)"122");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Teferi, Temporal Archmage", (String)"C14", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Teferi's Protection", (String)"C17", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Temporal Mastery", (String)"MM3", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tempt with Discovery", (String)"C16", (String)"170");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Thalia's Lancers", (String)"EMN", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"The Gitrog Monster", (String)"SOI", (String)"245");
        MysteryBooster.addCardInfoToList(boosterList, (String)"The Mirari Conjecture", (String)"DOM", (String)"57");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Tireless Tracker", (String)"SOI", (String)"233");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Torment of Hailfire", (String)"HOU", (String)"77");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trading Post", (String)"CM2", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Two-Headed Giant", (String)"DOM", (String)"147");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Urza's Rage", (String)"C15", (String)"169");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Vigor", (String)"BBD", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wheel of Fate", (String)"C16", (String)"138");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Whelming Wave", (String)"DDO", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Whir of Invention", (String)"AER", (String)"49");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yuriko, the Tiger's Shadow", (String)"C18", (String)"52");
    }

    private void addSlot15foil(List<CardInfo> boosterList) {
        MysteryBooster.addCardInfoToList(boosterList, (String)"Alchemist's Refuge", (String)"AVR", (String)"225");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Allosaurus Rider", (String)"CSP", (String)"101");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Amulet of Vigor", (String)"WWK", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Archetype of Endurance", (String)"BNG", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Aurelia's Fury", (String)"GTC", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Balduvian Rage", (String)"CSP", (String)"76");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Balefire Liege", (String)"EVE", (String)"132");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blasting Station", (String)"5DN", (String)"107");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Blighted Agent", (String)"NPH", (String)"29");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boreal Druid", (String)"CSP", (String)"105");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Boundless Realms", (String)"M13", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Braid of Fire", (String)"CSP", (String)"78");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bramblewood Paragon", (String)"MOR", (String)"115");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Bringer of the Black Dawn", (String)"5DN", (String)"43");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Burning Inquiry", (String)"M10", (String)"128");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Celestial Dawn", (String)"TSB", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Celestial Kirin", (String)"SOK", (String)"3");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Changeling Hero", (String)"LRW", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Chimney Imp", (String)"MRD", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Codex Shredder", (String)"RTR", (String)"228");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Conspiracy", (String)"TSB", (String)"39");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Council Guardian", (String)"CNS", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Delay", (String)"FUT", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Drogskol Captain", (String)"DKA", (String)"136");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Echoing Decay", (String)"DST", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Eidolon of Rhetoric", (String)"JOU", (String)"10");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fatespinner", (String)"MRD", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fiery Gambit", (String)"MRD", (String)"90");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Flamekin Harbinger", (String)"LRW", (String)"167");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Form of the Dragon", (String)"9ED", (String)"187");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Frozen Aether", (String)"PLC", (String)"54");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Funeral Charm", (String)"TSB", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Fungusaur", (String)"8ED", (String)"250");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Game-Trail Changeling", (String)"MOR", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Geth's Grimoire", (String)"DST", (String)"123");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gilder Bairn", (String)"EVE", (String)"152");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Gleeful Sabotage", (String)"SHM", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Glittering Wish", (String)"FUT", (String)"156");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Goblin Bushwhacker", (String)"ZEN", (String)"125");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Grand Architect", (String)"SOM", (String)"33");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Greater Mossdog", (String)"MMA", (String)"146");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Guerrilla Tactics", (String)"10E", (String)"211");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Harmonic Sliver", (String)"TSP", (String)"240");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Helix Pinnacle", (String)"EVE", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Herald of Leshrac", (String)"CSP", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Hornet Sting", (String)"M11", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Intruder Alarm", (String)"8ED", (String)"86");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Iron Myr", (String)"SOM", (String)"168");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Isamaru, Hound of Konda", (String)"CHK", (String)"19");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Karrthus, Tyrant of Jund", (String)"ARB", (String)"117");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Knowledge Pool", (String)"MBS", (String)"111");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Kulrath Knight", (String)"SHM", (String)"190");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lantern of Insight", (String)"5DN", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lapse of Certainty", (String)"CON", (String)"9");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Leveler", (String)"MRD", (String)"195");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lich's Mirror", (String)"ALA", (String)"210");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lightning Storm", (String)"CSP", (String)"89");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Lumithread Field", (String)"FUT", (String)"25");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maelstrom Nexus", (String)"ARB", (String)"130");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Magewright's Stone", (String)"DIS", (String)"162");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Manaweft Sliver", (String)"M14", (String)"184");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Maro", (String)"8ED", (String)"264");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Marrow-Gnawer", (String)"CHK", (String)"124");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Memnite", (String)"SOM", (String)"174");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Minamo, School at Water's Edge", (String)"CHK", (String)"279");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mind Funeral", (String)"MMA", (String)"181");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mindslaver", (String)"MRD", (String)"206");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Mirrodin's Core", (String)"DST", (String)"165");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Misthollow Griffin", (String)"AVR", (String)"68");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Myojin of Life's Web", (String)"CHK", (String)"229");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Nezumi Shortfang", (String)"CHK", (String)"131");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Noggle Bandit", (String)"EVE", (String)"106");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Norin the Wary", (String)"TSP", (String)"171");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Norn's Annex", (String)"NPH", (String)"17");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Not of This World", (String)"ROE", (String)"8");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ogre Gatecrasher", (String)"DIS", (String)"67");
        MysteryBooster.addCardInfoToList(boosterList, (String)"One with Nothing", (String)"SOK", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Panglacial Wurm", (String)"CSP", (String)"116");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Paradox Haze", (String)"TSP", (String)"71");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Patron of the Moon", (String)"BOK", (String)"45");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pili-Pala", (String)"SHM", (String)"258");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Proclamation of Rebirth", (String)"DIS", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Puca's Mischief", (String)"SHM", (String)"47");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pull from Eternity", (String)"TSP", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Pyretic Ritual", (String)"M11", (String)"153");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Ravenous Trap", (String)"ZEN", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reaper King", (String)"SHM", (String)"260");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Reki, the History of Kamigawa", (String)"SOK", (String)"142");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rescue from the Underworld", (String)"THS", (String)"102");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rhox", (String)"10E", (String)"291");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Rune-Tail, Kitsune Ascendant", (String)"SOK", (String)"27");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sakura-Tribe Scout", (String)"SOK", (String)"144");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sarkhan the Mad", (String)"ROE", (String)"214");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scourge of the Throne", (String)"CNS", (String)"35");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Scryb Ranger", (String)"TSP", (String)"215");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sen Triplets", (String)"ARB", (String)"109");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sheltering Ancient", (String)"CSP", (String)"121");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Shizo, Death's Storehouse", (String)"CHK", (String)"283");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sinew Sliver", (String)"PLC", (String)"30");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sosuke, Son of Seshiro", (String)"CHK", (String)"244");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Soul's Attendant", (String)"ROE", (String)"44");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spelltithe Enforcer", (String)"GPT", (String)"18");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spellweaver Volute", (String)"FUT", (String)"59");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Spike Feeder", (String)"TSB", (String)"84");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Springjack Shepherd", (String)"EVE", (String)"15");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stalking Stones", (String)"MRD", (String)"284");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Stigma Lasher", (String)"EVE", (String)"62");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Storm Crow", (String)"9ED", (String)"100");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Sundial of the Infinite", (String)"M12", (String)"218");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Teferi's Puzzle Box", (String)"8ED", (String)"316");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Trailblazer's Boots", (String)"ZEN", (String)"208");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Treasonous Ogre", (String)"CNS", (String)"36");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Triskelion", (String)"M11", (String)"218");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Undead Warchief", (String)"TSB", (String)"52");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Viscera Seer", (String)"M11", (String)"120");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wall of Shards", (String)"CSP", (String)"23");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Wear // Tear", (String)"DGM", (String)"135");
        MysteryBooster.addCardInfoToList(boosterList, (String)"White Knight", (String)"M10", (String)"41");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Witchbane Orb", (String)"ISD", (String)"236");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Yore-Tiller Nephilim", (String)"GPT", (String)"140");
        MysteryBooster.addCardInfoToList(boosterList, (String)"Zur's Weirding", (String)"8ED", (String)"116");
    }
}

