/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.watchers.common.SpellsCastWatcher;

class AJedisFervorEffect
extends OneShotEffect {
    public AJedisFervorEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "If an opponent cast a black spell this turn, that player sacrifices a creature or planeswalker.";
    }

    private AJedisFervorEffect(AJedisFervorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        Set opponents = game.getOpponents(source.getControllerId());
        HashSet<UUID> opponentsBlack = new HashSet<UUID>();
        ArrayList perms = new ArrayList();
        if (watcher != null) {
            for (UUID opponentId : opponents) {
                List spells = watcher.getSpellsCastThisTurn(opponentId);
                if (spells == null) continue;
                for (Spell spell : spells) {
                    if (!spell.getColor(game).isBlack()) continue;
                    opponentsBlack.add(opponentId);
                }
            }
        }
        for (UUID opponentId : opponentsBlack) {
            TargetSacrifice target = new TargetSacrifice(StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_PLANESWALKER);
            game.getPlayer(opponentId).choose(Outcome.Sacrifice, (Target)target, source, game);
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public AJedisFervorEffect copy() {
        return new AJedisFervorEffect(this);
    }
}

