/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.a.AbandonedSarcophagusWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AbandonedSarcophagusReplacementEffect
extends ReplacementEffectImpl {
    AbandonedSarcophagusReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If a card that has a cycling ability would be put into your graveyard from anywhere and it wasn't cycled, exile it instead";
    }

    private AbandonedSarcophagusReplacementEffect(AbandonedSarcophagusReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AbandonedSarcophagusReplacementEffect copy() {
        return new AbandonedSarcophagusReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            return controller.moveCards((Card)permanent, Zone.EXILED, source, game);
        }
        Card card = game.getCard(event.getTargetId());
        if (card != null) {
            return controller.moveCards(card, Zone.EXILED, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (((ZoneChangeEvent)event).getToZone() != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return false;
        }
        if (!card.isOwnedBy(controller.getId())) {
            return false;
        }
        AbandonedSarcophagusWatcher watcher = (AbandonedSarcophagusWatcher)game.getState().getWatcher(AbandonedSarcophagusWatcher.class);
        if (watcher == null) {
            return false;
        }
        boolean cardHasCycling = false;
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof CyclingAbility)) continue;
            cardHasCycling = true;
            break;
        }
        Cards cards = watcher.getCardsCycledThisTurn(controller.getId());
        boolean cardWasCycledThisTurn = false;
        for (Card cardCycledThisTurn : cards.getCards(game)) {
            if (cardCycledThisTurn != card) continue;
            cardWasCycledThisTurn = true;
            watcher.getCardsCycledThisTurn(controller.getId()).remove(card);
        }
        return !cardWasCycledThisTurn && cardHasCycling;
    }
}

