/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class AbstruseAppropriationAsThoughEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    private final MageObjectReference morCard;

    public AbstruseAppropriationAsThoughEffect(MageObjectReference mor) {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may spend colorless mana as though it were mana of any color to cast that spell";
        this.morCard = mor;
    }

    private AbstruseAppropriationAsThoughEffect(AbstruseAppropriationAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.morCard = effect.morCard;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public AbstruseAppropriationAsThoughEffect copy() {
        return new AbstruseAppropriationAsThoughEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card currentCard = game.getCard(this.morCard.getSourceId());
        if (currentCard == null || currentCard.getZoneChangeCounter(game) > this.morCard.getZoneChangeCounter() + 1) {
            this.discard();
            return false;
        }
        Zone zone = game.getState().getZone(currentCard.getId());
        if (zone != Zone.STACK && zone != Zone.EXILED) {
            this.discard();
            return false;
        }
        objectId = CardUtil.getMainCardId((Game)game, (UUID)objectId);
        return source.isControlledBy(affectedControllerId) && Objects.equals(objectId, currentCard.getId());
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        if (mana.getColorless() > 0) {
            return ManaType.COLORLESS;
        }
        return null;
    }
}

