/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AbuelosAwakeningContinuousEffect
extends ContinuousEffectImpl {
    AbuelosAwakeningContinuousEffect() {
        super(Duration.Custom, Outcome.Neutral);
        this.staticText = "It's a 1/1 Spirit creature with flying in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private AbuelosAwakeningContinuousEffect(AbuelosAwakeningContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AbuelosAwakeningContinuousEffect copy() {
        return new AbuelosAwakeningContinuousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature;
        if (source.getTargets().getFirstTarget() == null) {
            creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        } else {
            creature = game.getPermanent(source.getTargets().getFirstTarget());
            if (creature == null) {
                creature = game.getPermanentEntering(source.getTargets().getFirstTarget());
            }
        }
        if (creature == null) {
            this.used = true;
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                creature.addCardType(game, new CardType[]{CardType.CREATURE});
                creature.addSubType(game, new SubType[]{SubType.SPIRIT});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                creature.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                creature.getPower().setModifiedBaseValue(1);
                creature.getToughness().setModifiedBaseValue(1);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }
}

