/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class AbyssalPersecutorCannotWinEffect
extends ContinuousRuleModifyingEffectImpl {
    AbyssalPersecutorCannotWinEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, false, false);
        this.staticText = "You can't win the game and your opponents can't lose the game";
    }

    AbyssalPersecutorCannotWinEffect(AbyssalPersecutorCannotWinEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSES || event.getType() == GameEvent.EventType.WINS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getType() == GameEvent.EventType.LOSES && game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) || event.getType() == GameEvent.EventType.WINS && event.getPlayerId().equals(source.getControllerId());
    }

    public AbyssalPersecutorCannotWinEffect copy() {
        return new AbyssalPersecutorCannotWinEffect(this);
    }
}

