/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AcademicProbationRestrictionEffect
extends RestrictionEffect {
    AcademicProbationRestrictionEffect() {
        super(Duration.UntilYourNextTurn, Outcome.UnboostCreature);
        this.staticText = "choose target nonland permanent. Until your next turn, it can't attack or block, and its activated abilities can't be activated";
    }

    private AcademicProbationRestrictionEffect(AcademicProbationRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public AcademicProbationRestrictionEffect copy() {
        return new AcademicProbationRestrictionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getId());
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }
}

