/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class AcademyResearchersEffect
extends OneShotEffect {
    AcademyResearchersEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put an Aura card from your hand onto the battlefield attached to {this}.";
    }

    private AcademyResearchersEffect(AcademyResearchersEffect effect) {
        super((OneShotEffect)effect);
    }

    public AcademyResearchersEffect copy() {
        return new AcademyResearchersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterCard filterCardInHand = new FilterCard();
        filterCardInHand.add((Predicate)SubType.AURA.getPredicate());
        Player controller = game.getPlayer(source.getControllerId());
        Permanent academyResearchers = game.getPermanent(source.getSourceId());
        if (controller != null && academyResearchers != null) {
            Card auraInHand;
            filterCardInHand.add((Predicate)new AuraCardCanAttachToPermanentId(academyResearchers.getId()));
            TargetCardInHand target = new TargetCardInHand(0, 1, filterCardInHand);
            if (controller.choose(Outcome.PutCardInPlay, (Target)target, source, game) && (auraInHand = game.getCard(target.getFirstTarget())) != null) {
                game.getState().setValue("attachTo:" + auraInHand.getId(), (Object)academyResearchers);
                controller.moveCards(auraInHand, Zone.BATTLEFIELD, source, game);
                if (academyResearchers.addAttachment(auraInHand.getId(), source, game)) {
                    game.informPlayers(controller.getLogName() + " put " + auraInHand.getLogName() + " on the battlefield attached to " + academyResearchers.getLogName() + '.');
                    return true;
                }
            }
        }
        return false;
    }
}

