/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AcidicDaggerDestroyNonWallAbility
extends DelayedTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("non-Wall creature");

    AcidicDaggerDestroyNonWallAbility() {
        super((Effect)new DestroyTargetEffect(), Duration.EndOfTurn, false);
    }

    protected AcidicDaggerDestroyNonWallAbility(AcidicDaggerDestroyNonWallAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent damagedPermanent = game.getPermanent(event.getTargetId());
        Permanent attackingPermanent = game.getPermanent(event.getSourceId());
        Permanent targetedPermanent = game.getPermanent(this.getTargets().getFirstTarget());
        if (!(damagedPermanent != null && attackingPermanent != null && targetedPermanent != null && filter.match((Object)damagedPermanent, game) && ((DamagedEvent)event).isCombatDamage() && attackingPermanent.getId().equals(targetedPermanent.getId()))) {
            return false;
        }
        this.getTargets().clear();
        for (Effect effect : this.getEffects()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(damagedPermanent, game));
        }
        return true;
    }

    public AcidicDaggerDestroyNonWallAbility copy() {
        return new AcidicDaggerDestroyNonWallAbility(this);
    }

    public String getRule() {
        return "Whenever target creature deals combat damage to a non-Wall creature this turn, destroy that non-Wall creature.";
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.WALL.getPredicate()));
    }
}

