/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class AcidicDaggerSacrificeSourceAbility
extends DelayedTriggeredAbility {
    AcidicDaggerSacrificeSourceAbility() {
        super((Effect)new SacrificeSourceEffect(), Duration.EndOfTurn, false);
    }

    protected AcidicDaggerSacrificeSourceAbility(AcidicDaggerSacrificeSourceAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD && zEvent.getTarget() != null && zEvent.getTargetId().equals(this.getTargets().getFirstTarget())) {
            this.getTargets().clear();
            return true;
        }
        return false;
    }

    public AcidicDaggerSacrificeSourceAbility copy() {
        return new AcidicDaggerSacrificeSourceAbility(this);
    }

    public String getRule() {
        return "When the targeted creature leaves the battlefield this turn, sacrifice {this}.";
    }
}

