/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class AcolyteOfAfflictionEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("permanent card from your graveyard");

    AcolyteOfAfflictionEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill two cards, then you may return a permanent card from your graveyard to your hand.";
    }

    private AcolyteOfAfflictionEffect(AcolyteOfAfflictionEffect effect) {
        super((OneShotEffect)effect);
    }

    public AcolyteOfAfflictionEffect copy() {
        return new AcolyteOfAfflictionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.moveCards(player.getLibrary().getTopCards(game, 2), Zone.GRAVEYARD, source, game);
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter, true);
        if (!player.choose(Outcome.ReturnToHand, (Target)target, source, game)) {
            return true;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        player.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

