/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.functions.CopyApplier;

class ActivatedSleeperEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card in a graveyard that was put there from the battlefield this turn");

    ActivatedSleeperEffect() {
        super(Outcome.Benefit);
        this.staticText = "as a copy of any creature card in a graveyard that was put there from the battlefield this turn, except it's a Phyrexian in addition to its other types";
    }

    private ActivatedSleeperEffect(ActivatedSleeperEffect effect) {
        super((OneShotEffect)effect);
    }

    public ActivatedSleeperEffect copy() {
        return new ActivatedSleeperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return true;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card copyFromCard = game.getCard(target.getFirstTarget());
        if (copyFromCard != null) {
            CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)copyFromCard, source.getSourceId());
            copyEffect.setApplier(new CopyApplier(){

                public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
                    blueprint.addSubType(new SubType[]{SubType.PHYREXIAN});
                    return true;
                }
            });
            game.addEffect((ContinuousEffect)copyEffect, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
    }
}

