/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class AddleEffect
extends OneShotEffect {
    AddleEffect() {
        super(Outcome.Discard);
        this.staticText = "Choose a color. Target player reveals their hand and you choose a card of that color from it. That player discards that card.";
    }

    private AddleEffect(AddleEffect effect) {
        super((OneShotEffect)effect);
    }

    public AddleEffect copy() {
        return new AddleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game)) {
            ObjectColor color = choice.getColor();
            game.informPlayers(controller.getLogName() + " chooses " + color + '.');
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new ColorPredicate(color));
            DiscardCardYouChooseTargetEffect effect = new DiscardCardYouChooseTargetEffect(filter);
            return effect.apply(game, source);
        }
        return false;
    }
}

