/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AegisOfTheLegionTriggeredAbility
extends TriggeredAbilityImpl {
    AegisOfTheLegionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.SHIELD.createInstance()));
        this.setTriggerPhrase("Whenever equipped creature mentors a creature, ");
    }

    private AegisOfTheLegionTriggeredAbility(AegisOfTheLegionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MENTORED_CREATURE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachment = this.getSourcePermanentOrLKI(game);
        Permanent mentoredCreature = game.getPermanent(event.getTargetId());
        if (attachment == null || mentoredCreature == null || !event.getSourceId().equals(attachment.getAttachedTo())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(mentoredCreature, game));
        return true;
    }

    public AegisOfTheLegionTriggeredAbility copy() {
        return new AegisOfTheLegionTriggeredAbility(this);
    }
}

