/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AetherChargeEffect
extends OneShotEffect {
    AetherChargeEffect() {
        super(Outcome.Damage);
        this.staticText = "you may have it deal 4 damage to target opponent or planeswalker";
    }

    private AetherChargeEffect(AetherChargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherChargeEffect copy() {
        return new AetherChargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("damageSource");
        Permanent creature = game.getPermanent(creatureId);
        if (creature == null) {
            creature = (Permanent)game.getLastKnownInformation(creatureId, Zone.BATTLEFIELD);
        }
        if (creature != null) {
            return game.damagePlayerOrPermanent(source.getFirstTarget(), 4, creature.getId(), source, game, false, true) > 0;
        }
        return false;
    }
}

