/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class AetherSpikeEffect
extends OneShotEffect {
    AetherSpikeEffect() {
        super(Outcome.Detriment);
        this.staticText = ", then you may pay any amount of {E}. Counter that spell unless its controller pays {1} for each {E} paid this way";
    }

    private AetherSpikeEffect(AetherSpikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherSpikeEffect copy() {
        return new AetherSpikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numberToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "How many {E} do you want to pay?", source, game);
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        int numberPaid = 0;
        if (cost.pay(source, game, source, source.getControllerId(), true)) {
            numberPaid = numberToPay;
        }
        new CounterUnlessPaysEffect((Cost)new GenericManaCost(numberPaid)).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        return true;
    }
}

