/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AethericAmplifierDoublePermanentEffect
extends OneShotEffect {
    AethericAmplifierDoublePermanentEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on target permanent";
    }

    private AethericAmplifierDoublePermanentEffect(OneShotEffect effect) {
        super(effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Set<Counter> counters = permanent.getCounters(game).values().stream().map(counter -> CounterType.findByName((String)counter.getName()).createInstance(counter.getCount())).collect(Collectors.toSet());
        if (counters.isEmpty()) {
            return false;
        }
        counters.forEach(counter -> permanent.addCounters(counter, source, game));
        return true;
    }

    public AethericAmplifierDoublePermanentEffect copy() {
        return new AethericAmplifierDoublePermanentEffect(this);
    }
}

