/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AgathaOfTheVileCauldronEffect
extends CostModificationEffectImpl {
    AgathaOfTheVileCauldronEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Activated abilities of creatures you control cost {X} less to activate, where X is {this}'s power. This effect can't reduce the mana in that cost to less than one mana.";
    }

    private AgathaOfTheVileCauldronEffect(AgathaOfTheVileCauldronEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public AgathaOfTheVileCauldronEffect copy() {
        return new AgathaOfTheVileCauldronEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int amount = SourcePermanentPowerValue.NOT_NEGATIVE.calculate(game, source, (Effect)this);
        if (amount <= 0) {
            return true;
        }
        int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)amount, (int)1);
        if (reduceMax < 1) {
            return true;
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.getAbilityType().isActivatedAbility() || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Permanent permanent = abilityToModify.getSourcePermanentOrLKI(game);
        return permanent != null && permanent.isCreature(game);
    }
}

