/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AirtightAlibiReplacementEffect
extends ReplacementEffectImpl {
    AirtightAlibiReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "and can't become suspected";
    }

    private AirtightAlibiReplacementEffect(AirtightAlibiReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BECOME_SUSPECTED;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(event.getTargetId()::equals).orElse(false);
    }

    public AirtightAlibiReplacementEffect copy() {
        return new AirtightAlibiReplacementEffect(this);
    }
}

