/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class AjaniNacatlAvengerMinusFourEffect
extends OneShotEffect {
    private static final List<CardType> cardTypes = Arrays.asList(CardType.ARTIFACT, CardType.CREATURE, CardType.ENCHANTMENT, CardType.PLANESWALKER);

    AjaniNacatlAvengerMinusFourEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses an artifact, a creature, an enchantment and a planeswalker from among the nonland permanents they control, then sacrifices the rest.";
    }

    private AjaniNacatlAvengerMinusFourEffect(AjaniNacatlAvengerMinusFourEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjaniNacatlAvengerMinusFourEffect copy() {
        return new AjaniNacatlAvengerMinusFourEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List playerList = game.getOpponents(controller.getId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        HashSet<UUID> toKeep = new HashSet<UUID>();
        for (Player player : playerList) {
            for (CardType cardType : cardTypes) {
                String message = CardUtil.addArticle((String)cardType.toString());
                FilterNonlandPermanent filter = new FilterNonlandPermanent(message);
                filter.add((Predicate)cardType.getPredicate());
                filter.add((Predicate)new ControllerIdPredicate(player.getId()));
                if (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) == 0) continue;
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                toKeep.add(target.getFirstTarget());
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, source.getControllerId(), game)) {
            if (permanent == null || toKeep.contains(permanent.getId()) || !controller.hasOpponent(permanent.getControllerId(), game)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

