/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileAllEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class AjaniStrengthOfThePrideEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    AjaniStrengthOfThePrideEffect() {
        super(Outcome.Benefit);
        this.staticText = "If you have at least 15 life more than your starting life total, exile {this} and each artifact and creature your opponents control.";
    }

    private AjaniStrengthOfThePrideEffect(AjaniStrengthOfThePrideEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjaniStrengthOfThePrideEffect copy() {
        return new AjaniStrengthOfThePrideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getLife() < game.getStartingLife() + 15) {
            return false;
        }
        new ExileSourceEffect().apply(game, source);
        return new ExileAllEffect(filter).apply(game, source);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

