/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class AkimTheSoaringWindWatcher
extends Watcher {
    private final Map<UUID, TokenState> playerIds = new HashMap<UUID, TokenState>();

    AkimTheSoaringWindWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.CREATED_TOKEN) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent instanceof PermanentToken) {
            if (!this.playerIds.containsKey(permanent.getControllerId())) {
                this.playerIds.put(permanent.getControllerId(), TokenState.FirstToken);
            } else {
                this.playerIds.put(permanent.getControllerId(), TokenState.MoreThanOneToken);
            }
        }
    }

    public void reset() {
        this.playerIds.clear();
    }

    boolean firstToken(UUID playerId) {
        return this.playerIds.getOrDefault(playerId, TokenState.NoToken) == TokenState.FirstToken;
    }

    public static enum TokenState {
        NoToken,
        FirstToken,
        MoreThanOneToken;

    }
}

