/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.AttachedToPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AkiriFearlessVoyagerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.EQUIPMENT, "equipment attached to a creature you control");

    AkiriFearlessVoyagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may unattach an Equipment from a creature you control. If you do, tap that creature and it gains indestructible until end of turn.";
    }

    private AkiriFearlessVoyagerEffect(AkiriFearlessVoyagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public AkiriFearlessVoyagerEffect copy() {
        return new AkiriFearlessVoyagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(1, 1, filter, true);
        if (!target.canChoose(source.getControllerId(), source, game) || !player.chooseUse(this.outcome, "Unnattach an equipment from a creature you control?", source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent equipment = game.getPermanent(target.getFirstTarget());
        if (equipment == null) {
            return false;
        }
        Permanent creature = game.getPermanent(equipment.getAttachedTo());
        if (creature == null) {
            return false;
        }
        creature.removeAttachment(equipment.getId(), source, game);
        creature.tap(source, game);
        game.addEffect(new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(creature, game)), source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new AttachedToPredicate((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE));
    }
}

