/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AkoumHellkiteDamageEffect
extends OneShotEffect {
    AkoumHellkiteDamageEffect() {
        super(Outcome.Damage);
    }

    private AkoumHellkiteDamageEffect(AkoumHellkiteDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public AkoumHellkiteDamageEffect copy() {
        return new AkoumHellkiteDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent land = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (land == null) {
            return false;
        }
        int damage = land.hasSubtype(SubType.MOUNTAIN, game) ? 2 : 1;
        Player player = game.getPlayer(source.getFirstTarget());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null && permanent == null) {
            return false;
        }
        if (player != null) {
            player.damage(damage, source.getSourceId(), source, game);
        } else {
            permanent.damage(damage, source.getSourceId(), source, game);
        }
        return true;
    }
}

