/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.a.AlacrianArmoryAnimateEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class AlacrianArmory
extends CardImpl {
    private static final FilterCreaturePermanent creatureFilter = new FilterCreaturePermanent("Creatures you control");
    private static final FilterPermanent mountOrVehicleFilter = new FilterPermanent("Mount or Vehicle you control");

    public AlacrianArmory(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}{W}");
        SimpleStaticAbility staticAbility = new SimpleStaticAbility((Effect)new BoostControlledEffect(0, 1, Duration.WhileOnBattlefield, (FilterPermanent)creatureFilter));
        GainAbilityControlledEffect effect = new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)creatureFilter);
        effect.setText("and have vigilance");
        staticAbility.addEffect((Effect)effect);
        this.addAbility((Ability)staticAbility);
        BeginningOfCombatTriggeredAbility animateAbility = new BeginningOfCombatTriggeredAbility((Effect)new AlacrianArmoryAnimateEffect());
        animateAbility.addTarget((Target)new TargetPermanent(0, 1, mountOrVehicleFilter));
        this.addAbility((Ability)animateAbility);
    }

    private AlacrianArmory(AlacrianArmory card) {
        super((CardImpl)card);
    }

    public AlacrianArmory copy() {
        return new AlacrianArmory(this);
    }

    static {
        mountOrVehicleFilter.add(Predicates.or((Predicate)SubType.MOUNT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        mountOrVehicleFilter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

