/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.cards.a.AlaniaDivergentStormWatcher;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

enum AlaniaDivergentStormCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)((Effect)source.getEffects().get(0)).getValue("spellCast");
        if (spell == null) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        SpellAbility sourceCastAbility = sourcePermanent.getSpellAbility();
        MageObjectReference sourceSpellMOR = new MageObjectReference(sourceCastAbility.getId(), sourcePermanent.getZoneChangeCounter(game) - 1, game);
        AlaniaDivergentStormWatcher watcher = (AlaniaDivergentStormWatcher)game.getState().getWatcher(AlaniaDivergentStormWatcher.class);
        UUID spellControllerID = spell.getControllerId();
        MageObjectReference spellMOR = new MageObjectReference((MageObject)spell, game);
        return watcher.spellIsFirstISOCast(spellControllerID, spellMOR, sourceSpellMOR);
    }

    public String toString() {
        return "it's the first instant spell, the first sorcery spell, or the first Otter spell other than {this} you've cast this turn";
    }
}

