/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class AlchemistsGambitEffect
extends ReplacementEffectImpl {
    private final UUID turnId;

    public AlchemistsGambitEffect(UUID turnId) {
        super(Duration.Custom, Outcome.Benefit);
        this.turnId = turnId;
    }

    private AlchemistsGambitEffect(AlchemistsGambitEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.turnId = effect.turnId;
    }

    public AlchemistsGambitEffect copy() {
        return new AlchemistsGambitEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PREVENT_DAMAGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return this.turnId != null && this.turnId.equals(game.getState().getExtraTurnId());
    }
}

