/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AleatoryEffect
extends OneShotEffect {
    AleatoryEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, target creature gets +1/+1 until end of turn";
    }

    private AleatoryEffect(AleatoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null && controller.flipCoin(source, game, true)) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(1, 1, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public AleatoryEffect copy() {
        return new AleatoryEffect(this);
    }
}

