/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AliFromCairoReplacementEffect
extends ReplacementEffectImpl {
    AliFromCairoReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private AliFromCairoReplacementEffect(AliFromCairoReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AliFromCairoReplacementEffect copy() {
        return new AliFromCairoReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        return controller.getLife() > 0 && controller.getLife() - event.getAmount() < 1 && event.getPlayerId().equals(controller.getId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        event.setAmount(controller.getLife() - 1);
        return false;
    }
}

