/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class AllureOfTheUnknownEffect
extends OneShotEffect {
    AllureOfTheUnknownEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top six cards of your library. An opponent exiles a nonland card from among them, then you put the rest into your hand. That opponent may cast the exiled card without paying its mana cost.";
    }

    private AllureOfTheUnknownEffect(AllureOfTheUnknownEffect effect) {
        super((OneShotEffect)effect);
    }

    public AllureOfTheUnknownEffect copy() {
        return new AllureOfTheUnknownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        player.revealCards(source, (Cards)cards, game);
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) == 0) {
            return player.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        TargetOpponent targetOpponent = new TargetOpponent(true);
        if (!player.choose(this.outcome, (Target)targetOpponent, source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        opponent.choose(Outcome.Exile, (Cards)cards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (player.moveCards(card, Zone.EXILED, source, game) && card != null && game.getState().getZone(card.getId()) == Zone.EXILED) {
            cards.remove(card);
        }
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        CardUtil.castSpellWithAttributesForFree((Player)opponent, (Ability)source, (Game)game, (Card)card);
        return true;
    }
}

