/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AltarOfDementiaEffect
extends OneShotEffect {
    AltarOfDementiaEffect() {
        super(Outcome.Damage);
        this.staticText = "Target player mills cards equal to the sacrificed creature's power";
    }

    private AltarOfDementiaEffect(AltarOfDementiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            int amount = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
                amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getPower().getValue();
                break;
            }
            if (amount > 0) {
                player.millCards(amount, source, game);
            }
            return true;
        }
        return false;
    }

    public AltarOfDementiaEffect copy() {
        return new AltarOfDementiaEffect(this);
    }
}

