/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AltarOfShadowsEffect
extends OneShotEffect {
    AltarOfShadowsEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "add {B} for each charge counter on {this}";
    }

    private AltarOfShadowsEffect(AltarOfShadowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AltarOfShadowsEffect copy() {
        return new AltarOfShadowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int chargeCounters;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (sourcePermanent != null && player != null && (chargeCounters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE)) > 0) {
            player.getManaPool().addMana(Mana.BlackMana((int)chargeCounters), game, source);
            return true;
        }
        return false;
    }
}

