/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class AnafenzaTheForemostEffect
extends ReplacementEffectImpl {
    AnafenzaTheForemostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a nontoken creature an opponent owns would die or a creature card not on the battlefield would be put into an opponent's graveyard, exile that card instead";
    }

    private AnafenzaTheForemostEffect(AnafenzaTheForemostEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AnafenzaTheForemostEffect copy() {
        return new AnafenzaTheForemostEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
                Permanent permanent = ((ZoneChangeEvent)event).getTarget();
                if (permanent != null && !(permanent instanceof PermanentToken)) {
                    return controller.moveCards((Card)permanent, Zone.EXILED, source, game);
                }
            } else {
                Card card = game.getCard(event.getTargetId());
                if (card != null) {
                    return controller.moveCards(card, Zone.EXILED, source, game);
                }
            }
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && (card = game.getCard(event.getTargetId())) != null && game.getOpponents(source.getControllerId()).contains(card.getOwnerId()) && (zEvent.getTarget() != null ? zEvent.getTarget().isCreature(game) : card.isCreature(game));
    }
}

