/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class AncientBrassDragonTarget
extends TargetCardInGraveyard {
    private final int xValue;

    AncientBrassDragonTarget(int xValue) {
        super(0, Integer.MAX_VALUE, (FilterCard)new FilterCreatureCard("creature cards with total mana value " + xValue + " or less from graveyards"), false);
        this.xValue = xValue;
    }

    private AncientBrassDragonTarget(AncientBrassDragonTarget target) {
        super((TargetCardInGraveyard)target);
        this.xValue = target.xValue;
    }

    public AncientBrassDragonTarget copy() {
        return new AncientBrassDragonTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, MageObject::getManaValue, (int)this.xValue, (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), MageObject::getManaValue, (int)this.xValue, (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        return super.getMessage(game) + " (selected total mana value " + selectedValue + ")";
    }
}

