/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class AncientBronzeDragonEffect
extends OneShotEffect {
    AncientBronzeDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d20. When you do, put X +1/+1 counters on each of up to two target creatures, where X is the result";
    }

    private AncientBronzeDragonEffect(AncientBronzeDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public AncientBronzeDragonEffect copy() {
        return new AncientBronzeDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 20);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(result)), false);
        ability.addTarget((Target)new TargetCreaturePermanent(0, 2));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

