/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AngelOfDestinyWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AngelOfDestinyLoseEffect
extends OneShotEffect {
    AngelOfDestinyLoseEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player {this} attacked this turn loses the game";
    }

    private AngelOfDestinyLoseEffect(AngelOfDestinyLoseEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelOfDestinyLoseEffect copy() {
        return new AngelOfDestinyLoseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AngelOfDestinyWatcher watcher = (AngelOfDestinyWatcher)game.getState().getWatcher(AngelOfDestinyWatcher.class);
        if (watcher == null) {
            return false;
        }
        Set<UUID> playerSet = watcher.getPlayers(new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game));
        if (playerSet == null) {
            return false;
        }
        for (UUID playerId : playerSet) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.lost(game);
        }
        return true;
    }
}

