/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AngelOfSufferingEffect
extends ReplacementEffectImpl {
    AngelOfSufferingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "If damage would be dealt to you, prevent that damage and mill twice that many cards";
    }

    private AngelOfSufferingEffect(AngelOfSufferingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AngelOfSufferingEffect copy() {
        return new AngelOfSufferingEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int cardsToMill = event.getAmount() * 2;
        game.preventDamage(event, source, game, Integer.MAX_VALUE);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.millCards(cardsToMill, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getControllerId());
    }
}

