/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AngelicChorusEffect
extends OneShotEffect {
    AngelicChorusEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to its toughness";
    }

    private AngelicChorusEffect(AngelicChorusEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelicChorusEffect copy() {
        return new AngelicChorusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("lifeSource");
        Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
        if (creature != null) {
            int amount = creature.getToughness().getValue();
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }
}

