/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.a.AngelicChorusEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AngelicChorusTriggeredAbility
extends TriggeredAbilityImpl {
    public AngelicChorusTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AngelicChorusEffect(), false);
    }

    private AngelicChorusTriggeredAbility(AngelicChorusTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.controllerId)) {
            ((Effect)this.getEffects().get(0)).setValue("lifeSource", (Object)event.getTargetId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control enters, you gain life equal to its toughness.";
    }

    public AngelicChorusTriggeredAbility copy() {
        return new AngelicChorusTriggeredAbility(this);
    }
}

