/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedHashSet;
import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AngelicSkirmisherEffect
extends OneShotEffect {
    AngelicSkirmisherEffect() {
        super(Outcome.AddAbility);
        this.staticText = "choose first strike, vigilance, or lifelink. Creatures you control gain that ability until end of turn";
    }

    private AngelicSkirmisherEffect(AngelicSkirmisherEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            ChoiceImpl abilityChoice = new ChoiceImpl(true);
            LinkedHashSet<String> abilityChoices = new LinkedHashSet<String>(3);
            abilityChoice.setMessage("Choose ability for your creatures");
            abilityChoices.add("First strike");
            abilityChoices.add("Vigilance");
            abilityChoices.add("Lifelink");
            abilityChoice.setChoices(abilityChoices);
            if (controller.choose(this.outcome, (Choice)abilityChoice, game)) {
                FirstStrikeAbility ability = null;
                switch (abilityChoice.getChoice()) {
                    case "First strike": {
                        ability = FirstStrikeAbility.getInstance();
                        break;
                    }
                    case "Vigilance": {
                        ability = VigilanceAbility.getInstance();
                        break;
                    }
                    case "Lifelink": {
                        ability = LifelinkAbility.getInstance();
                        break;
                    }
                }
                if (ability != null) {
                    GainAbilityControlledEffect effect = new GainAbilityControlledEffect((Ability)ability, Duration.EndOfTurn, (FilterPermanent)new FilterControlledCreaturePermanent());
                    game.addEffect((ContinuousEffect)effect, source);
                    game.informPlayers(sourcePermanent.getName() + ": " + controller.getLogName() + " has chosen " + abilityChoice.getChoice().toLowerCase(Locale.ENGLISH));
                    return true;
                }
            }
        }
        return false;
    }

    public AngelicSkirmisherEffect copy() {
        return new AngelicSkirmisherEffect(this);
    }
}

