/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class AngelsGraceEffect
extends ContinuousRuleModifyingEffectImpl {
    AngelsGraceEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, false, false);
        this.staticText = "You can't lose the game this turn and your opponents can't win the game this turn";
    }

    private AngelsGraceEffect(AngelsGraceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AngelsGraceEffect copy() {
        return new AngelsGraceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.WINS || event.getType() == GameEvent.EventType.LOSES;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getType() == GameEvent.EventType.WINS && game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) || event.getType() == GameEvent.EventType.LOSES && event.getPlayerId().equals(source.getControllerId());
    }
}

