/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AngelsGraceReplacementEffect
extends ReplacementEffectImpl {
    AngelsGraceReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Until end of turn, damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private AngelsGraceReplacementEffect(AngelsGraceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AngelsGraceReplacementEffect copy() {
        return new AngelsGraceReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        if (event.getPlayerId().equals(source.getControllerId()) && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() > 0 && controller.getLife() - event.getAmount() < 1) {
            event.setAmount(controller.getLife() - 1);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return false;
    }
}

