/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedThisTurnWatcher;

class AngelsTrumpetTapEffect
extends OneShotEffect {
    AngelsTrumpetTapEffect() {
        super(Outcome.Tap);
        this.staticText = "tap all untapped creatures that player controls that didn't attack this turn. {this} deals damage to the player equal to the number of creatures tapped this way";
    }

    private AngelsTrumpetTapEffect(AngelsTrumpetTapEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngelsTrumpetTapEffect copy() {
        return new AngelsTrumpetTapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            int count = 0;
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
                AttackedThisTurnWatcher watcher;
                if (creature.isTapped() || (watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class)) != null && watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)creature, game))) continue;
                creature.tap(source, game);
                ++count;
            }
            if (count > 0) {
                player.damage(count, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

