/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AngrathMinotaurPirateThirdAbilityEffect
extends OneShotEffect {
    AngrathMinotaurPirateThirdAbilityEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures target opponent controls. {this} deals damage to that player equal to their total power";
    }

    private AngrathMinotaurPirateThirdAbilityEffect(AngrathMinotaurPirateThirdAbilityEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngrathMinotaurPirateThirdAbilityEffect copy() {
        return new AngrathMinotaurPirateThirdAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetOpponent != null) {
            int powerSum = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getSourceId(), game)) {
                permanent.destroy(source, game, false);
                powerSum += permanent.getPower().getValue();
            }
            game.processAction();
            targetOpponent.damage(powerSum, source.getSourceId(), source, game);
        }
        return true;
    }
}

