/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class AnheloThePainterWatcher
extends Watcher {
    private final Map<UUID, MageObjectReference> playerMap = new HashMap<UUID, MageObjectReference>();

    AnheloThePainterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.CAST_SPELL) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return;
        }
        this.playerMap.computeIfAbsent(event.getPlayerId(), x -> new MageObjectReference((MageObject)spell.getMainCard(), game));
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    static boolean checkSpell(StackObject stackObject, Game game) {
        if (stackObject.isCopy() || !(stackObject instanceof Spell)) {
            return false;
        }
        UUID controllerId = stackObject.getControllerId();
        AnheloThePainterWatcher watcher = (AnheloThePainterWatcher)game.getState().getWatcher(AnheloThePainterWatcher.class);
        return watcher.playerMap.containsKey(controllerId) && watcher.playerMap.get(controllerId).refersTo((MageObject)((Spell)stackObject).getMainCard(), game);
    }
}

