/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AniktheaHandOfErebosEffect
extends OneShotEffect {
    AniktheaHandOfErebosEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target non-Aura enchantment card from your graveyard. Create a token that's a copy of that card, except it's a 3/3 black Zombie creature in addition to its other types";
    }

    private AniktheaHandOfErebosEffect(AniktheaHandOfErebosEffect effect) {
        super((OneShotEffect)effect);
    }

    public AniktheaHandOfErebosEffect copy() {
        return new AniktheaHandOfErebosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        new CreateTokenCopyTargetEffect().setPermanentModifier(token -> {
            token.addCardType(new CardType[]{CardType.CREATURE});
            token.addSubType(new SubType[]{SubType.ZOMBIE});
            token.setColor(ObjectColor.BLACK);
            token.setPower(3);
            token.setToughness(3);
        }).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        return true;
    }
}

