/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnimationModuleEffect
extends OneShotEffect {
    AnimationModuleEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose a counter on target permanent or player. Give that permanent or player another counter of that kind";
    }

    private AnimationModuleEffect(AnimationModuleEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnimationModuleEffect copy() {
        return new AnimationModuleEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Counters counters;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) return false;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (permanent.getCounters(game).isEmpty()) return true;
            if (permanent.getCounters(game).size() == 1) {
                for (Counter counter : permanent.getCounters(game).values()) {
                    Counter newCounter = new Counter(counter.getName());
                    permanent.addCounters(newCounter, source.getControllerId(), source, game);
                }
                return true;
            }
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (Counter counter : permanent.getCounters(game).values()) {
                choices.add(counter.getName());
            }
            choice.setChoices(choices);
            choice.setMessage("Choose a counter");
            if (!controller.choose(Outcome.Benefit, (Choice)choice, game)) return false;
            for (Counter counter : permanent.getCounters(game).values()) {
                if (!counter.getName().equals(choice.getChoice())) continue;
                Counter newCounter = new Counter(counter.getName());
                permanent.addCounters(newCounter, source.getControllerId(), source, game);
                return true;
            }
            return true;
        }
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || (counters = player.getCountersAsCopy()).isEmpty()) return true;
        if (counters.size() == 1) {
            for (Counter counter : counters.values()) {
                Counter newCounter = new Counter(counter.getName());
                player.addCounters(newCounter, source.getControllerId(), source, game);
            }
            return true;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        for (Counter counter : counters.values()) {
            choices.add(counter.getName());
        }
        choice.setChoices(choices);
        choice.setMessage("Choose a counter");
        if (!controller.choose(Outcome.Benefit, (Choice)choice, game)) return false;
        for (Counter counter : counters.values()) {
            if (!counter.getName().equals(choice.getChoice())) continue;
            Counter newCounter = new Counter(counter.getName());
            player.addCounters(newCounter, source.getControllerId(), source, game);
            return true;
        }
        return true;
    }
}

