/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ServoToken;
import mage.game.permanent.token.Token;

class AnimationModuleTriggeredAbility
extends TriggeredAbilityImpl {
    AnimationModuleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new CreateTokenEffect((Token)new ServoToken()), (Cost)new GenericManaCost(1)), false);
    }

    private AnimationModuleTriggeredAbility(AnimationModuleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AnimationModuleTriggeredAbility copy() {
        return new AnimationModuleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.P1P1.getName())) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            return permanent != null && permanent.isControlledBy(this.getControllerId());
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more +1/+1 counters are put on a permanent you control, you may pay {1}. If you do, create a 1/1 colorless Servo artifact creature token.";
    }
}

